/*
 * MFFloat.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _MFFLOAT_H
#define _MFFLOAT_H

#ifndef _ARRAY_H
#include "Array.h"
#endif
#ifndef _FIELD_VALUE_H
#include "FieldValue.h"
#endif
#ifndef _SFFLOAT_H
#include "SFFloat.h"
#endif

class MFFloat : public MFieldValue {
public:
			MFFloat(int stride = 1);
			MFFloat(float *values, int len, int stride = 1);
			MFFloat(const MFFloat &value);
			MFFloat(float value);
    virtual 	       ~MFFloat();

    virtual int         getType() const { return MFFLOAT; }
    virtual int         getStride() const { return 1; }
    virtual const char *getTypeName() const { return "MFFloat"; }
    virtual int		write(int filedes, int indent) const;
    virtual bool	equals(const FieldValue *value) const;
    virtual void	clamp(const FieldValue *min, const FieldValue *max);
    virtual FieldValue *copy() { return new MFFloat(*this); }

    virtual int		getSFSize() const { return _len / getStride(); }
    virtual FieldValue *getSFValue(int index) const { return new SFFloat(_value[index]); }
    virtual void	setSFValue(int index, FieldValue *value);

    const float	       *getValues() const { return _value; }
    float		getValue(int i) const { return _value[i]; }
    int			getSize() const { return _len; }
    void		setValue(int index, float value) { _value[index] = value; }

    MyString	        getEcmaScriptComment(MyString name, int flags) const;

    bool                isAnimateable() const { return false; }

protected:
    bool		equals(const MFFloat *value) const;

protected:
    int			_len;
    float	       *_value;
};

#endif // _MFFLOAT_H
