/*
 * MFString.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "stdafx.h"

#include "MFString.h"
#include "SFString.h"
#include "DuneApp.h"

MFString::MFString()
{
    _value = new StringArray();
}

MFString::MFString(StringArray *values)
{
    _value = values;
}

MFString::MFString(MyString value)
{
    _value =  new StringArray();
    _value->append(value);
}

MFString::MFString(const MFString &string)
{
    _value = new StringArray(*string._value);
}

MFString::~MFString()
{
    delete _value;
}

int MFString::write(int f, int indent) const
{
#ifndef HAVE_KR_LIKE_INDENT
    RET_ONERROR( mywritestr(f, "\n") )
    TheApp->incSelectionLinenumber();
    RET_ONERROR( indentf(f, indent+2) )
#endif
    RET_ONERROR( mywritestr(f, "[\n") )
    TheApp->incSelectionLinenumber();
    for (int i = 0; i < _value->size(); i++) {
	RET_ONERROR( indentf(f, indent+2) )
	RET_ONERROR( mywritestr(f, "\"") )
	RET_ONERROR( mywritestr(f, (const char *) _value->get(i)) )
	RET_ONERROR( mywritestr(f, "\"\n") )
        TheApp->incSelectionLinenumber();
    }
#ifndef HAVE_KR_LIKE_INDENT
    RET_ONERROR( indentf(f, indent+2) )
#else
    RET_ONERROR( indentf(f, indent) )
#endif
    RET_ONERROR( mywritestr(f, "]\n") )
    TheApp->incSelectionLinenumber();
    return(0);
}

bool
MFString::equals(const FieldValue *value) const
{
    if (value->getType() == MFSTRING) {
	MFString	*v = (MFString *) value;
	if (v->getSize() != _value->size()) return false;
	for (int i = 0; i < _value->size(); i++)
	    if (v->getValue(i) != _value->get(i)) return false;
	return true;
    }
    return false;
}

FieldValue *
MFString::getSFValue(int index) const
{
    return new SFString(_value->get(index)); 
}

void
MFString::setSFValue(int index, FieldValue *value)
{
    _value->set(index, ((SFString *) value)->getValue());
}


MyString
MFString::getEcmaScriptComment(MyString name, int flags) const
{
    const char *indent = ((FieldValue *)this)->getEcmaScriptIndent(flags);
    MyString ret;
    ret = "";
    if (TheApp->GetEcmaScriptAddAllowedValues()) {
        ret += indent;
        ret += "// allowed values:\n";

        ret += indent;
        ret += "   // array ([0] [1] [2] ...) of 'string value's \n";
    }
    if (TheApp->GetEcmaScriptAddAvailableFunctions()) {
        ret += indent;
        ret += "// available functions:\n";
        if (flags != EL_EVENT_IN) {
            ret += indent;
            ret += "   // ";
            ret += name;
            ret += " = new MFString(string_s1, string_s2, ...);\n";
        }
        if (flags != EL_EVENT_OUT) {
            ret += indent;
            ret += "   // int_i = ";
            ret += name;
            ret += ".length();\n";

            ret += indent;
            ret += "   // string_str = ";
            ret += name;
            ret += ".toString();\n";
       }
    }
    if (TheApp->GetEcmaScriptAddBrowserObject()) {
        if (flags != EL_EVENT_OUT) {
            ret += indent;
            ret += "// related Browser Object functions:\n";

            ret += indent;
            ret += "   // Browser.createVrmlFromURL(";
            ret += name;
            ret += ", sfnode_n, string_event);\n";

            ret += indent;
            ret += "   // Browser.loadURL(";
            ret += name;
            ret += ", mfstring_parameter);\n";
        }
    }
    if (TheApp->GetEcmaScriptAddExampleUsage()) {
        ret += indent;
        ret += "// example usage:\n";
        if (flags != EL_EVENT_IN) {
            ret += indent;
            ret += "   // ";
            ret += name;
            ret += " = new MFString('hello','world');\n";

            ret += indent;
            ret += "   // ";
            ret += name;
            ret += "[0] = ' hello ';\n";

            ret += indent;
            ret += "   // ";
            ret += name;
            ret += "[1] = Browser.getName();\n";

        } 
        if (flags != EL_EVENT_OUT) {
            ret += indent;
            ret += "   // Browser.loadURL(";
            ret += name;
            ret += ", new MFString());\n";
        }
    }
    return ret;
}

void 
MFString::insertSFValue(int index, FieldValue *value)
{
    _value->insert(((SFString *)value)->getValue() ,index);
}
