/*
 * MFTime.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h> 
#include "stdafx.h"

#include "MFTime.h"
#include "SFTime.h"
#include "DuneApp.h"

MFTime::MFTime()
{
    _len = 0;
    _value = NULL;
}

MFTime::MFTime(const MFTime &value)
{
    _len = value._len;
    _value = new double[value._len];
    memcpy(_value, value._value, _len * sizeof(double));
}

MFTime::MFTime(double *value, int len)
{
    _value = value;
    _len = len;
}

MFTime::MFTime(const float *value, int len)
{
    _len = len;
    _value = new double[_len];
    for (int i=0;i<len;i++)
       _value[i]=value[i];
}

bool
MFTime::equals(const FieldValue *value) const
{
    return value->getType() == MFTIME && equals((const MFTime *) value);
}

bool
MFTime::equals(const MFTime *value) const
{
    if (_len == value->_len) {
	for (int i = 0; i < _len; i++)
	    if (_value[i] != value->_value[i])
		return false;
	return true;
    }
    return false;
}

int MFTime::write(int f, int indent) const
{
#ifndef HAVE_KR_LIKE_INDENT
    RET_ONERROR( mywritestr(f, "\n") )
    TheApp->incSelectionLinenumber();
    RET_ONERROR( indentf(f, indent+2) )
#endif
    RET_ONERROR( mywritestr(f, "[\n") )
    TheApp->incSelectionLinenumber();
    for (int i = 0; i < _len; i++) {
	RET_ONERROR( indentf(f, indent+2) )
	RET_ONERROR( mywritef(f, "%g\n", _value[i]) )
        TheApp->incSelectionLinenumber();
    }
#ifndef HAVE_KR_LIKE_INDENT
    RET_ONERROR( indentf(f, indent+2) )
#else
    RET_ONERROR( indentf(f, indent) )
#endif
    RET_ONERROR( mywritestr(f, "]\n") )
    TheApp->incSelectionLinenumber();
    return(0);
}

void MFTime::clamp(const FieldValue *min, const FieldValue *max)
{
    if (min) {
	double	dmin = ((SFTime *) min)->getValue();
	for (int i = 0; i < _len; i++) {
	    if (_value[i] < dmin) _value[i] = dmin;
	}
    }
    if (max) {
	double	dmax = ((SFTime *) max)->getValue();
	for (int i = 0; i < _len; i++) {
	    if (_value[i] > dmax) _value[i] = dmax;
	}
    }
}

void MFTime::setSFValue(int index, FieldValue *value)
{
    _value[index] = ((SFTime *) value)->getValue();
}


MyString
MFTime::getEcmaScriptComment(MyString name, int flags) const
{
    const char *indent = ((FieldValue *)this)->getEcmaScriptIndent(flags);
    MyString ret;
    ret = "";
    if (TheApp->GetEcmaScriptAddAllowedValues()) {
        ret += indent;
        ret += "// allowed values:\n";

        ret += indent;
        ret += "   //  array ([0] [1] [2] ...) of double-precision floating numbers\n";
        ret += indent;
        ret += "   //  time since Jan 1, 1970, 00:00:00 GMT in seconds\n";
    }
    if (TheApp->GetEcmaScriptAddAvailableFunctions()) {
        ret += indent;
        ret += "// available functions:\n";
        if (flags != EL_EVENT_IN) {
            ret += indent;
            ret += "   // ";
            ret += name;
            ret += " = new MFTime(sftime_t1, sftime_t2, ...);\n";
        }
        if (flags != EL_EVENT_OUT) {
            ret += indent;
            ret += "   // int_i = ";
            ret += name;
            ret += ".length();\n";

            ret += indent;
            ret += "   // string_str = ";
            ret += name;
            ret += ".toString();\n";
       }
    }
    if (TheApp->GetEcmaScriptAddExampleUsage()) {
        ret += indent;
        ret += "// example usage:\n";
        if (flags != EL_EVENT_IN) {
             ret += indent;
             ret += "   // ";
             ret += name;
             ret += " = new MFTime(0.2, 3.7, 8, -123.34);\n";

             ret += indent;
             ret += "   // ";
             ret += name;
             ret += "[0] = 0.0;\n";
        } 
        if (flags != EL_EVENT_OUT) {
             ret += indent;
             ret += "   // number = ";
             ret += name;
             ret += "[0];\n";
        }
    }
    return ret;
}
