/*
 * MFVec2f.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _MFVEC2F_H
#define _MFVEC2F_H

#ifndef _MFFLOAT_H
#include "MFFloat.h"
#endif

class MFVec2f : public MFFloat {
public:
			MFVec2f();
			MFVec2f(float *values, int len);

    virtual int		getType() const { return MFVEC2F; }
    virtual const char *getTypeName() const { return "MFVec2f"; }
    virtual int		getStride() const { return 2; }
    virtual bool	equals(const FieldValue *value) const;
    virtual FieldValue *copy() { return new MFVec2f(*this); }
    const float	       *getValue(int index) const { return _value + index * 2; } 

    virtual FieldValue *getSFValue(int index) const;
    virtual void	setSFValue(int index, FieldValue *value);

    MyString	        getEcmaScriptComment(MyString name, int flags) const;

    // VRML200x CoordinateInterpolator2D not implemented yet
    bool                isAnimateable() const { return false; }
    bool                hasAnimationSupport() { return false; }
};

#endif // _MFVEC2F_H
