/*
 * NodeBackground.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "stdafx.h"

#include "NodeBackground.h"
#include "Proto.h"
#include "FieldValue.h"
#include "MFColor.h"
#include "MFFloat.h"
#include "MFString.h"
#include "SFColor.h"
#include "SFRotation.h"
#include "NodeImageTexture.h"
#include "NodeViewpoint.h"
#include "Scene.h"
#include "Util.h"
#include "Field.h"	    // for FF_URL

ProtoBackground::ProtoBackground(Scene *scene)
  : Proto(scene, "Background")
{
    addEventIn(SFBOOL, "set_bind");

    groundAngle.set(
          addExposedField(MFFLOAT, "groundAngle", new MFFloat(), 
                          new SFFloat(0.0f), new SFFloat(PI / 2.0f)));
    groundColor.set(
         addExposedField(MFCOLOR, "groundColor", new MFColor()));
    frontUrl.set(
         addExposedField(MFSTRING, "frontUrl", new MFString(), FF_URL, NULL));
    rightUrl.set(
         addExposedField(MFSTRING, "rightUrl", new MFString(), FF_URL, NULL));
    backUrl.set(
         addExposedField(MFSTRING, "backUrl", new MFString(), FF_URL, NULL));
    leftUrl.set(
         addExposedField(MFSTRING, "leftUrl", new MFString(), FF_URL, NULL));
    topUrl.set(
         addExposedField(MFSTRING, "topUrl", new MFString(), FF_URL, NULL));
    bottomUrl.set(
         addExposedField(MFSTRING, "bottomUrl", new MFString(), FF_URL, NULL));
    skyAngle.set(
         addExposedField(MFFLOAT, "skyAngle", new MFFloat(), new SFFloat(0.0f),
    		         new SFFloat(PI)));

    float	       *colors = new float[3];
    colors[0] = colors[1] = colors[2] = 0.0f;
    skyColor.set(
          addExposedField(MFCOLOR, "skyColor", new MFColor(colors, 3)));
    addEventOut(SFBOOL, "isBound");
}

Node *
ProtoBackground::create(Scene *scene)
{ 
    return new NodeBackground(scene, this); 
}

NodeBackground::NodeBackground(Scene *scene, Proto *def)
  : Node(scene, def)
{
    for (int i = 0; i < 6; i++) {
	imageTextures[i] = (NodeImageTexture *) scene->createNode("ImageTexture");
	imageTextures[i]->ref();
    }
}

NodeBackground::~NodeBackground()
{
    for (int i = 0; i < 6; i++) {
	imageTextures[i]->unref();
    }
}

void
NodeBackground::setField(int field, FieldValue *value)
{
    if (field >= 2 && field <= 7) {
	imageTextures[field - 2]->url((MFString *)value);
    }

    Node::setField(field, value);
}

void
NodeBackground::apply()
{
    for (int j = 0; j < 6; j++) {
	if (!imageTextures[j]->isLoaded())
	    imageTextures[j]->load();
    }
    const float	   *r = _scene->getCamera()->orientation()->getValue();
    glPushAttrib(GL_ENABLE_BIT);
    glDisable(GL_DEPTH_TEST);
    glDisable(GL_LIGHTING);
    glDisable(GL_FOG);
    glPushMatrix();
    glLoadIdentity();
    glRotatef(-RAD2DEG(r[3]), r[0], r[1], r[2]);
    glScalef(40.0f, 40.0f, 40.0f);

    for (int i = 0; i < 6; i++) {
	if (imageTextures[i]->isLoaded())
	{
	    imageTextures[i]->bind();
	    glBegin(GL_POLYGON);
	    for (int j = 0; j < 4; j++) {
		glTexCoord2fv( boxTexCoords[j] );
		glVertex3fv( boxCorners[boxIndices[i*4+j]] );
	    }
	    glEnd();
	    imageTextures[i]->unbind();
	}
    }

    glPopMatrix();
    glPopAttrib();
}

void
NodeBackground::preDraw()
{
    _scene->addBackground(this);
}
