/*
 * NodeCoordinateInterpolator.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _NODE_COORDINATEINTERPOLATOR_H
#define _NODE_COORDINATEINTERPOLATOR_H

#ifndef _INTERPOLATOR_H
#include "Interpolator.h"
#endif
#ifndef _PROTO_MACROS_H
#include "ProtoMacros.h"
#endif

#include "SFMFTypes.h"

class ProtoCoordinateInterpolator : public ProtoInterpolator {
public:
		    ProtoCoordinateInterpolator(Scene *scene);
    virtual Node   *create(Scene *scene);
};

class NodeCoordinateInterpolator : public Interpolator {
public:
			NodeCoordinateInterpolator(Scene *scene, Proto *proto);

    virtual int	        getType() const { return NODE_COORDINATE_INTERPOLATOR; }
    virtual Node       *copy() const { return new NodeCoordinateInterpolator(*this); }

    virtual int		getNumChannels() const;
    virtual FieldValue *createKey(float *value) const;
    virtual FieldValue *createKeys(float *values, int numKeys) const;
    virtual void	recordKey(FieldValue *value);

    fieldMacros(MFVec3f, keyValue, ProtoCoordinateInterpolator)

protected:
    int			_keySize;
};

#endif // _NODE_COORDINATEINTERPOLATOR_H
