/*
 * NodeCylinder.h
 *
 * Copyright (C) 1999 Stephen F. White
 *               2003 Th. Rothermel
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _NODE_CYLINDER_H
#define _NODE_CYLINDER_H

#ifndef _NODE_H
#include "Node.h"
#endif
#ifndef _PROTO_MACROS_H
#include "ProtoMacros.h"
#endif
#ifndef _PROTO_H
#include "Proto.h"
#endif

#include "SFMFTypes.h"

class ProtoCylinder : public Proto {
public:
		    ProtoCylinder(Scene *scene);
    virtual Node   *create(Scene *scene);

    FieldIndex bottom;
    FieldIndex height;
    FieldIndex radius;
    FieldIndex side;
    FieldIndex top;
};

class NodeCylinder : public Node {
public:
		    NodeCylinder(Scene *scene, Proto *proto);

    virtual int	    getType() const { return NODE_CYLINDER; }
    virtual Node   *copy() const { return new NodeCylinder(*this); }
    virtual int	    getNodeClass() const { return NODE_GEOMETRY; }
    virtual void    draw();
    virtual Node   *toNurbs(int nshell, int narea, int narcs, int uDegree, int vDegree);

    fieldMacros(SFBool,  bottom, ProtoCylinder)
    fieldMacros(SFFloat, height, ProtoCylinder)
    fieldMacros(SFFloat, radius, ProtoCylinder)
    fieldMacros(SFBool,  side,   ProtoCylinder)
    fieldMacros(SFBool,  top,    ProtoCylinder)
};

#endif // _NODE_CYLINDER_H
