/*
 * NodeExtrusion.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "stdafx.h"

#include "NodeExtrusion.h"
#include "Proto.h"
#include "FieldValue.h"
#include "SFBool.h"
#include "SFFloat.h"
#include "MFVec2f.h"
#include "MFVec3f.h"
#include "MFRotation.h"


ProtoExtrusion::ProtoExtrusion(Scene *scene)
  : Proto(scene, "Extrusion")
{
    float      *v;

    addEventIn(MFVEC2F, "set_crossSection");
    addEventIn(MFROTATION, "set_orientation");
    addEventIn(MFVEC2F, "set_scale");
    addEventIn(MFVEC3F, "set_spine");
    beginCap.set(
          addField(SFBOOL, "beginCap", new SFBool(true)));
    ccw.set(
          addField(SFBOOL, "ccw", new SFBool(true)));
    convex.set(
          addField(SFBOOL, "convex", new SFBool(true)));
    creaseAngle.set(
          addField(SFFLOAT, "creaseAngle", new SFFloat(0.0f), 
                   new SFFloat(0.0f)));

    float	values[] = { 1.0, 1.0, 1.0, -1.0, -1.0, -1.0 };
    v = new float[6];  memcpy(v, values, 6 * sizeof(float));
    crossSection.set(
          addField(MFVEC2F, "crossSection", new MFVec2f(v, 6)));
    endCap.set(
          addField(SFBOOL, "endCap", new SFBool(true)));

    float	values2[] = { 0.0, 0.0, 1.0, 0.0 };
    v = new float[4];  memcpy(v, values, 4 * sizeof(float));
    orientation.set(
          addField(MFROTATION, "orientation", new MFRotation(v, 4)));

    float	values3[] = { 1.0, 1.0 };
    v = new float[2];  memcpy(v, values3, 2 * sizeof(float));
    scale.set(
          addField(MFVEC2F, "scale", new MFVec2f(v, 2), new SFFloat(0.0f)));
    solid.set(
          addField(SFBOOL, "solid", new SFBool(true)));

    float	values4[] = { 1.0, 1.0, 0.0, 0.0, 1.0, 0.0 };
    v = new float[6];  memcpy(v, values4, 6 * sizeof(float));
    spine.set(
          addField(MFVEC3F, "spine", new MFVec3f(v, 6)));
}

Node *
ProtoExtrusion::create(Scene *scene)
{ 
    return new NodeExtrusion(scene, this); 
}

NodeExtrusion::NodeExtrusion(Scene *scene, Proto *def)
  : Node(scene, def)
{
}

