/*
 * NodeNormal.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "stdafx.h"

#include "NodeNormal.h"
#include "Proto.h"
#include "FieldValue.h"
#include "MFVec3f.h"

#include "NodeIndexedFaceSet.h"

ProtoNormal::ProtoNormal(Scene *scene)
  : Proto(scene, "Normal")
{
    vector.set(
          addExposedField(MFVEC3F, "vector", new MFVec3f()));
}

Node *
ProtoNormal::create(Scene *scene)
{
    return new NodeNormal(scene, this); 
}

NodeNormal::NodeNormal(Scene *scene, Proto *def)
  : Node(scene, def)
{
}

void
NodeNormal::setNormalFromIndexedFaceSet()
{
    Node* parent = ((Node *)this)->getParent();
    if (parent->getType() == NODE_INDEXED_FACE_SET) {
        NodeIndexedFaceSet *faceSet = (NodeIndexedFaceSet*) parent;
        MFVec3f *v = faceSet->getSmoothNormals();
        if (v != NULL)
            vector(v);
        MFInt32 *ni = faceSet->getSmoothNormalIndex();
        if (ni != NULL)
            faceSet->normalIndex(ni);
        faceSet->normalPerVertex(new SFBool(true));
    }

}

