/*
 * NodeNormalInterpolator.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "stdafx.h"

#include "NodeNormalInterpolator.h"
#include "Proto.h"
#include "FieldValue.h"
#include "MFFloat.h"
#include "MFVec3f.h"
#include "SFVec3f.h"

ProtoNormalInterpolator::ProtoNormalInterpolator(Scene *scene)
  : ProtoInterpolator(scene, "NormalInterpolator", MFVEC3F, MFVEC3F,
                      new MFVec3f())
{
}

Node *
ProtoNormalInterpolator::create(Scene *scene)
{
    return new NodeNormalInterpolator(scene, this); 
}

NodeNormalInterpolator::NodeNormalInterpolator(Scene *scene, Proto *def)
  : Interpolator(scene, def)
{
}

int
NodeNormalInterpolator::getNumChannels() const
{
    int	 numKeys = ((NodeNormalInterpolator *)this)->key()->getSize();

    return numKeys == 0 ? 0 : 
          ((NodeNormalInterpolator *)this)->keyValue()->getSize() / numKeys;
}

FieldValue *
NodeNormalInterpolator::createKey(float *value) const
{
    FieldValue *r = new SFVec3f(value);
    delete value;
    return r;
}

FieldValue *
NodeNormalInterpolator::createKeys(float *value, int numKeys) const
{
    return new MFVec3f(value, numKeys * 3);
}

void
NodeNormalInterpolator::interpolate(float k, float *values)
{
    int	     i, numVectors = getNumChannels() / 3;

    if (keyValue()->getSize() == 0) {
	for (i = 0; i < numVectors; i++) {
	    values[i*3]   = 0.0f;
	    values[i*3+1] = 1.0f;
	    values[i*3+2] = 0.0f;
	}
    }

    float   k1, k2;
    int	    pos1, pos2;

    getNearestKeys(k, &k1, &k2, &pos1, &pos2);

    float	    alpha = (k - k1) / (k2 - k1);

    for (i = 0; i < numVectors; i++) {
	Vec3f	    v1(keyValue()->getValue(pos1 * numVectors + i));
	Vec3f	    v2(keyValue()->getValue(pos2 * numVectors + i));
	Vec3f	    v(v1 + (v2 - v1) * alpha);
	v.normalize();
	memcpy(values + i*3, (const float *) &v, 3 * sizeof(float));
    }
}
