/*
 * NodeNurbsGroup.cpp
 *
 * Copyright (C) 1999 Stephen F. White, 2003 J. "MUFTI" Scheurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#ifndef FLT_MAX
# include <float.h>
#endif
#include "stdafx.h"

#include "NodeNurbsGroup.h"
#include "Proto.h"
#include "FieldValue.h"
#include "MFNode.h"
#include "SFVec3f.h"
#include "SFFloat.h"
#include "DuneApp.h"
#include "NodeNurbsSurface.h"
#include "NodeShape.h"
#include "Scene.h"

ProtoNurbsGroup::ProtoNurbsGroup(Scene *scene)
  : ProtoGroup(scene, "NurbsGroup")
{
    tessellationScale.set(
          addExposedField(SFFLOAT, "tessellationScale", new SFFloat(1.0f), 
    	      	          new SFFloat(0.0f), new SFFloat(FLT_MAX)));
}

Node *
ProtoNurbsGroup::create(Scene *scene)
{ 
    return new NodeNurbsGroup(scene, this); 
}

NodeNurbsGroup::NodeNurbsGroup(Scene *scene, Proto *def)
  : NodeGroup(scene, def)
{
}

bool
NodeNurbsGroup::writeEXTERNPROTO(int f)
{
    RET_ONERROR( mywritestr(f ,"EXTERNPROTO NurbsGroup[\n") )    
    TheApp->incSelectionLinenumber();
    RET_ONERROR( mywritestr(f ," eventIn       MFNode   addChildren\n") )
    TheApp->incSelectionLinenumber();
    RET_ONERROR( mywritestr(f ," eventIn       MFNode   removeChildren\n") )
    TheApp->incSelectionLinenumber();
    RET_ONERROR( mywritestr(f ," exposedField  MFNode   children\n") )
    TheApp->incSelectionLinenumber();
    RET_ONERROR( mywritestr(f ," exposedField  SFFloat  tessellationScale\n") )
    TheApp->incSelectionLinenumber();
    RET_ONERROR( mywritestr(f ," field         SFVec3f  bboxCenter\n") )
    TheApp->incSelectionLinenumber();
    RET_ONERROR( mywritestr(f ," field         SFVec3f  bboxSize\n") )
    TheApp->incSelectionLinenumber();
    RET_ONERROR( mywritestr(f ," ]\n") )
    TheApp->incSelectionLinenumber();
    RET_ONERROR( mywritestr(f ,"[\n") )
    TheApp->incSelectionLinenumber();
    RET_ONERROR( mywritestr(f ," \"urn:web3d:vrml97:node:NurbsGroup\",\n") )
    TheApp->incSelectionLinenumber();
    RET_ONERROR( mywritestr(f ," \"urn:inet:blaxxun.com:node:NurbsGroup\",\n") )
    TheApp->incSelectionLinenumber();
    RET_ONERROR( mywritestr(f ," \"urn:ParaGraph:NurbsGROUP\",\n") )
    TheApp->incSelectionLinenumber();
#ifdef HAVE_NURBSGROUP_PROTO_URL
    RET_ONERROR( mywritestr(f ," \"") )
    RET_ONERROR( mywritestr(f ,HAVE_NURBSGROUP_PROTO_URL) )
    RET_ONERROR( mywritestr(f ,"\"\n") )
    TheApp->incSelectionLinenumber();
#else
    RET_ONERROR( mywritestr(f ," \"NurbsGroupPROTO.wrl\",\n") )
    TheApp->incSelectionLinenumber();
#endif
    RET_ONERROR( mywritestr(f ," \"http://www.csv.ica.uni-stuttgart.de/vrml/dune/docs/vrml200x_nurbssurface/NurbsGroupPROTO.wrl\"\n") )
    TheApp->incSelectionLinenumber();
    RET_ONERROR( mywritestr(f ,"]\n") )
    TheApp->incSelectionLinenumber();
    return true;
}

   
int             
NodeNurbsGroup::write(int filedes, int indent) 
{
    if (_scene->isPureVRML97()) {
        NodeGroup group(this);
        RET_ONERROR( group.write(filedes, indent) )
    } else
        RET_ONERROR( NodeData::write(filedes, indent) )
    return 0;
}

void
NodeNurbsGroup::setHandle(Node* caller, float newWeight,
                          const Vec3f &newV, const Vec3f &oldV)
{
    int		i;
    NodeList   *childList = children()->getValues();
    for (i = 0; i < childList->size(); i++) {
	Node *child = childList->get(i);
        if (child->getType() == NODE_NURBS_SURFACE) {
            if (child != caller)
                ((NodeNurbsSurface *)child)->setHandle(newWeight, newV, oldV);
        } else if (child->getType() == NODE_SHAPE) {
            Node *node = ((NodeShape *)child)->geometry()->getValue();
            if ((node != caller) && (node->getType() == NODE_NURBS_SURFACE))
                ((NodeNurbsSurface *)node)->setHandle(newWeight, newV, oldV);
        }
    }
}

void
NodeNurbsGroup::backupFieldsAppend(Node* caller, int field)
{
    int		i;
    NodeList   *childList = children()->getValues();
    for (i = 0; i < childList->size(); i++) {
	Node *child = childList->get(i);
        if (child->getType() == NODE_NURBS_SURFACE) {
            if (child != caller)
                _scene->backupFieldsAppend(child, field);
        } else if (child->getType() == NODE_SHAPE) {
            Node *node = ((NodeShape *)child)->geometry()->getValue();
            if ((node != caller) && (node->getType() == NODE_NURBS_SURFACE))
                _scene->backupFieldsAppend(node, field);
        }
    }
}

