/*
 * NodeNurbsSurface.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _NODE_NURBS_SURFACE_H
#define _NODE_NURBS_SURFACE_H

#ifndef _NODE_H
#include "Node.h"
#endif
#ifndef _PROTO_MACROS_H
#include "ProtoMacros.h"
#endif
#ifndef _PROTO_H
#include "Proto.h"
#endif

#include "SFMFTypes.h"

class Vec3f;
class Mesh;
class NodeNurbsGroup;

class ProtoNurbsSurface : public Proto {
public:
		    ProtoNurbsSurface(Scene *scene);
    virtual Node   *create(Scene *scene);

    FieldIndex uDimension;
    FieldIndex vDimension;
    FieldIndex uKnot;
    FieldIndex vKnot;
    FieldIndex uOrder;
    FieldIndex vOrder;
    FieldIndex controlPoint;
    FieldIndex weight;
    FieldIndex uTessellation;
    FieldIndex vTessellation;
    FieldIndex texCoord;
    FieldIndex ccw;
    FieldIndex solid;
};

class NodeNurbsSurface : public Node {
public:
		    NodeNurbsSurface(Scene *scene, Proto *proto);
protected:
    virtual	   ~NodeNurbsSurface();

public:
    virtual int	    getType() const { return NODE_NURBS_SURFACE; }
    virtual Node   *copy() const { return new NodeNurbsSurface(*this); }
    virtual int	    getNodeClass() const { return NODE_NURBS_GEOMETRY; }
    int             cleanDoubleVertices(int *coordIndex, Vec3f *vertices,
                                        Vec3f *normals, int index);

    virtual void    draw();
    virtual void    drawHandles();

    virtual Vec3f   getHandle(int handle, int *constraint, int *field);
    virtual void    setHandle(int handle, const Vec3f &v);

    virtual void    setField(int index, FieldValue *value);

    Node           *toIndexedFaceSet(void);

    void	    rotate(SFRotation rot);

    void            update(void) { _meshDirty = true; }
    void            reInit(void) { _mesh = NULL; _meshDirty = true; }

    bool    	    writeEXTERNPROTO(int filedes);
    int		    write(int filedes, int indent);

    fieldMacros(SFInt32, uDimension,    ProtoNurbsSurface)
    fieldMacros(SFInt32, vDimension,    ProtoNurbsSurface)
    fieldMacros(MFFloat, uKnot,         ProtoNurbsSurface)
    fieldMacros(MFFloat, vKnot,         ProtoNurbsSurface)
    fieldMacros(SFInt32, uOrder,        ProtoNurbsSurface)
    fieldMacros(SFInt32, vOrder,        ProtoNurbsSurface)
    fieldMacros(MFVec3f, controlPoint,  ProtoNurbsSurface)
    fieldMacros(MFFloat, weight,        ProtoNurbsSurface)
    fieldMacros(SFInt32, uTessellation, ProtoNurbsSurface)
    fieldMacros(SFInt32, vTessellation, ProtoNurbsSurface)
    fieldMacros(SFNode,  texCoord,      ProtoNurbsSurface)
    fieldMacros(SFBool,  ccw,           ProtoNurbsSurface)
    fieldMacros(SFBool,  solid,         ProtoNurbsSurface)

    virtual void    setHandle(MFVec3f *newValue, int handle, float newWeight,
                              const Vec3f &newV, const Vec3f &oldV,
                              bool already_changed = false);
    virtual void    setHandle(float newWeight, 
                              const Vec3f &newV, const Vec3f &oldV);
    NodeNurbsGroup *findNurbsGroup();

protected:
    void	    createMesh();
    static int	    findSpan(int dimension, int order, float u,
    			     const float knots[]);
    static void     basisFuns(int span, float u, int order,
    			      const float knots[], float basis[],
			      float deriv[]);
    static Vec3f    surfacePoint(int uDimension, int uOrder,
    				 const float uKnots[],
                                 int vDimension, int vOrder,
				 const float vKnots[],
			         const Vec3f controlPoints[],
				 const float weights[],
				 float u, float v, Vec3f &normal);
private:
    Mesh	   *_mesh;
    bool	    _meshDirty;
};

#endif // _NODE_NURBS_SURFACE_H
