/*
 * NodeProximitySensor.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "stdafx.h"

#include "NodeProximitySensor.h"
#include "Proto.h"
#include "FieldValue.h"
#include "SFVec3f.h"
#include "SFFloat.h"
#include "SFBool.h"


ProtoProximitySensor::ProtoProximitySensor(Scene *scene)
  : Proto(scene, "ProximitySensor")
{
    center.set(
          addExposedField(SFVEC3F, "center", new SFVec3f(0.0f, 0.0f, 0.0f)));
    size.set(
          addExposedField(SFVEC3F, "size", new SFVec3f(0.0f, 0.0f, 0.0f), 
                          new SFFloat(0.0f)));
    enabled.set(
          addExposedField(SFBOOL, "enabled", new SFBool(true)));
    addEventOut(SFBOOL, "isActive");
    addEventOut(SFVEC3F, "position_changed");
    addEventOut(SFROTATION, "orientation_changed");
    addEventOut(SFTIME, "enterTime");
    addEventOut(SFTIME, "exitTime");
}

Node *
ProtoProximitySensor::create(Scene *scene)
{ 
    return new NodeProximitySensor(scene, this); 
}

NodeProximitySensor::NodeProximitySensor(Scene *scene, Proto *def)
  : Node(scene, def)
{
}

