/*
 * NodeScript.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _NODE_SCRIPT_H
#define _NODE_SCRIPT_H

#ifndef _NODE_H
#include "Node.h"
#endif
#ifndef _PROTO_MACROS_H
#include "ProtoMacros.h"
#endif
#ifndef _PROTO_H
#include "Proto.h"
#endif
#include "SFMFTypes.h"
#include "CommandList.h"

class ProtoScript : public Proto {
public:
		    ProtoScript(Scene *scene);
    virtual Node   *create(Scene *scene);

    FieldIndex url;
    FieldIndex directOutput;
    FieldIndex mustEvaluate;
};

#define SCRIPT_URL_FIELD 0

class MyString;

class InterfaceData {
public:
    InterfaceData(int elementEnum, int elementIndex) 
       { _elementEnum=elementEnum; _elementIndex=elementIndex; }
    
    int _elementEnum;
    int _elementIndex;
};

typedef Array<InterfaceData *> InterfaceArray;

class NodeScript : public Node {
public:
		    NodeScript(Scene *scene);
		    NodeScript(Node *node,Proto* proto) : 
                               Node(*node,proto) {}
    void	    addEventIn(int fieldType, const MyString &name)
                       {
                       getProto()-> addEventIn(fieldType, name);
                       }
    void	    addEventOut(int fieldType, const MyString &name)
                       {
                       getProto()-> addEventOut(fieldType, name);
                       }
    int		    getUrlField();

    fieldMacros(MFString, url,          ProtoScript)
    fieldMacros(SFBool,   directOutput, ProtoScript)
    fieldMacros(SFBool,   mustEvaluate, ProtoScript)
protected:
    virtual	   ~NodeScript();
    void	    buildInterfaceData(void); 
    void            updateEventIn(int newIndex, int oldIndex);
    void            updateEventOut(int newIndex, int oldIndex);

public:
    virtual int	    getType() const { return NODE_SCRIPT; }
    virtual Node   *copy() const { return new NodeScript(*this); }
    virtual int     write(int filedes, int indent);
    int             writeField(int f, int indent, int fieldIndex);
    virtual int     writeFields(int filedes, int indent);

    virtual void    update();

    InterfaceArray *getInterfaceData(void) 
                        {
                        buildInterfaceData();
                        return _interface;
                        } 

private:
    InterfaceArray *_interface;
    CommandList    *_routeList;
};

#endif // _NODE_SCRIPT_H
