/*
 * PreferencesApp.h
 *
 * Copyright (C) 1999 Stephen F. White, 2003 J. "MUFTI" Scheurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _PREFERENCES_APP_H
#define _PREFERENCES_APP_H

#include "swttypedef.h"

typedef enum {
    HM_NONE,
    HM_SELECTED,
    HM_ALL,
    HM_TREE
} HandleMode;

class PreferencesApp {
public:

                        PreferencesApp();

    void		SavePreferences(void);

    STABLE		getPrefs() { return _prefs; }

    // PreferencesApp data
    HandleMode	        GetHandleMode() const { return _handleMode; }
    float	        GetHandleSize();
    bool		GetShowAllFields() const { return _showAllFields; }
    int			GetRotationOrder() const { return _rotationOrder; }
    const char	       *GetRotationTitle() const { return _rotationTitle; }

    bool                GetEcmaScriptAddInitialise() const 
                              { return _ecmaScriptAddInitialise; }
    bool                GetEcmaScriptAddShutdown() const 
                              { return _ecmaScriptAddShutdown; }
    bool                GetEcmaScriptAddEventsProcessed() const 
                              { return _ecmaScriptAddEventsProcessed; }
    bool                GetEcmaScriptAddAvailableFunctions() const 
                              { return _ecmaScriptAddAvailableFunctions; }
    bool                GetEcmaScriptAddAllowedValues() const 
                              { return _ecmaScriptAddAllowedValues; }
    bool                GetEcmaScriptAddAllowedComponents() const 
                              { return _ecmaScriptAddAllowedComponents; }
    bool                GetEcmaScriptAddExampleUsage() const 
                              { return _ecmaScriptAddExampleUsage; }

    bool                GetEcmaScriptAddMathObject() const
                              { return _ecmaScriptAddMathObject; }
    bool                GetEcmaScriptAddBrowserObject() const
                              { return _ecmaScriptAddBrowserObject; }

    float               GetEpsilon(void)
                              { return _epsilon; }
                              

    void    		SetHandleMode(HandleMode handleMode);
    void	        SetHandleSize(float size);
    void		SetShowAllFields(bool s);
    void		SetRotationOrder(int rotationOrder);
    void		SetRotationTitle(const char *s)
						{ _rotationTitle = s; }

    void                SetEcmaScriptAddInitialise(bool s)
                              { _ecmaScriptAddInitialise = s; }
    void                SetEcmaScriptAddShutdown(bool s)
                              { _ecmaScriptAddShutdown = s; }
    void                SetEcmaScriptAddEventsProcessed(bool s)
                              { _ecmaScriptAddEventsProcessed = s; }
    void                SetEcmaScriptAddAvailableFunctions(bool s)
                              { _ecmaScriptAddAvailableFunctions =s; }
    void                SetEcmaScriptAddAllowedValues(bool s)
                              { _ecmaScriptAddAllowedValues = s; }
    void                SetEcmaScriptAddAllowedComponents(bool s)
                              { _ecmaScriptAddAllowedComponents = s; }
    void                SetEcmaScriptAddExampleUsage(bool s)
                              { _ecmaScriptAddExampleUsage = s; }

    void                SetEcmaScriptAddMathObject(bool s)
                              { _ecmaScriptAddMathObject = s; }
    void                SetEcmaScriptAddBrowserObject(bool s)
                              { _ecmaScriptAddBrowserObject = s; }

    void                SetEpsilon(float f)
                              { _epsilon = f; }

    bool		GetBoolPreference(const char *key, bool defaultValue);
    int			GetIntPreference(const char *key, int defaultValue);
    const char	       *GetPreference(const char *key,
    				      const char *defaultValue);

    void		SetBoolPreference(const char *key, bool value);
    void		SetIntPreference(const char *key, int value);
    void		SetPreference(const char *key, const char *value);

private: 

    STABLE		_prefs;

    bool		_showAllFields;
    int			_rotationOrder;
    const char	       *_rotationTitle;
    HandleMode		_handleMode;
    float               _handleSize;
    bool                _ecmaScriptAddInitialise;
    bool                _ecmaScriptAddShutdown;
    bool                _ecmaScriptAddEventsProcessed;
    bool                _ecmaScriptAddAvailableFunctions;
    bool                _ecmaScriptAddAllowedValues;
    bool                _ecmaScriptAddAllowedComponents;
    bool                _ecmaScriptAddExampleUsage;
    bool                _ecmaScriptAddMathObject;
    bool                _ecmaScriptAddBrowserObject;
    float               _epsilon;
};

#endif
