/*
 * SFBool.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _SFBOOL_H
#define _SFBOOL_H

#ifndef _FIELDVALUE_H
#include "FieldValue.h"
#endif

class SFBool : public FieldValue {
public:
			SFBool(bool value);
			SFBool(void) { _value = true; } // silly default

    virtual int         getType() const { return SFBOOL; }
    virtual const char *getTypeName() const { return "SFBool"; }
    virtual int         write(int filedes, int indent) const;
    virtual bool        equals(const FieldValue *value) const;
    virtual FieldValue *copy() { return new SFBool(*this); }

    bool		getValue() const { return _value; }

    MyString   	        getEcmaScriptComment(MyString name, int flags) const;

    // VRML 200x BooleanSequencer not implemented yet
    bool                isAnimateable() const { return false; }
    bool                hasAnimationSupport() { return false; }

private:
    bool		_value;
};

#endif // _SFBOOL_H
