/*
 * SFImage.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <string.h>
#include "stdafx.h"

#include "SFImage.h"
#include "DuneApp.h"

SFImage::SFImage(int width, int height, int depth, const int *pixels)
{
    _width = width;
    _height = height;
    _depth = depth;
    _pixels.resize(width * height);
    for (int i = 0; i < width * height; i++)
	_pixels[i] = pixels[i];
}

SFImage::SFImage(void)
{
    _width = 1;
    _height = 1;
    _depth = 3;
    _pixels.resize(_width * _height);
    for (int i = 0; i < _width * _height; i++)
	_pixels[i] = 0xFFFFFF;
}


int SFImage::write(int f, int indent) const
{
    RET_ONERROR( mywritef(f, "%d %d %d\n", _width, _height, _depth) )
    for (int i = 0; i < _width * _height; i++) {
	RET_ONERROR( indentf(f, indent+2) )
	RET_ONERROR( mywritef(f, "0x%08x\n", _pixels[i]) )
        TheApp->incSelectionLinenumber();
    }
    return 0;
}

bool
SFImage::equals(const FieldValue *value) const
{
    if (value->getType() == SFIMAGE) {
	SFImage		*v = (SFImage *) value;

	return v->getWidth() == _width
	    && v->getHeight() == _height
	    && v->getDepth() == _depth
	    && !memcmp(v->getPixels(), _pixels.getData(), _width * _height);
    }
    return false;
}

MyString
SFImage::getEcmaScriptComment(MyString name, int flags) const
{
    const char *indent = ((FieldValue *)this)->getEcmaScriptIndent(flags);
    MyString ret;
    ret = "";
    if (TheApp->GetEcmaScriptAddAllowedValues()) {
        ret += indent;
        ret += "// allowed values:\n";

        ret += indent;
        ret += "   // 3 integer values + ";
        ret += name;
        ret += "[0]*";
        ret += name;
        ret += "[1]*";
        ret += name;
        ret += "[2] byte (range 0-256) values\n";
    }
    if (TheApp->GetEcmaScriptAddAllowedComponents()) {
        ret += indent;
        ret += "// allowed components:\n";

        ret += indent;
        ret += "   // width  of image: ";
        ret += name;
        ret += "[0]\n";

        ret += indent;
        ret += "   // height of image: ";
        ret += name;
        ret += "[1]\n";

        ret += indent;
        ret += "   // number of components of image (e.g. 3 for rgb, 4 for rgba): ";
        ret += name;
        ret += "[2]\n";

        ret += indent;
        ret += "   // the following numbers represent pixel values \n";
        ret += indent;
        ret += "   // pixel value: integer with (number of components) bytes (0-255))\n";
    }
    if (TheApp->GetEcmaScriptAddAvailableFunctions()) {
        ret += indent;
        ret += "// available functions:\n";
        if (flags != EL_EVENT_IN) {
            ret += indent;
            ret += "   // ";
            ret += name;
            ret += " = new SFImage(numeric_x, numeric_y, numeric_comp, mfint32_iarray);\n";
        }
        if (flags != EL_EVENT_OUT) {
            ret += indent;
            ret += "   // string_str = ";
            ret += name;
            ret += ".toString();\n";
       }
    }
    if (TheApp->GetEcmaScriptAddExampleUsage()) {
        ret += indent;
        ret += "// example usage:\n";
        if (flags != EL_EVENT_IN) {
             ret += indent;
             ret += "   // ";
             ret += name;
             ret += " = new SFImage(2, 1, 3,  ";
             ret += "new MFInt32(0xFF0000,0x0000FF));\n";
        } 
        if (flags != EL_EVENT_OUT) {
             ret += indent;
             ret += "   // int_height = ";
             ret += name;
             ret += "[1];\n";
        }
    }
    return ret;
}
