/*
 * Util.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _UTIL_H
#define _UTIL_H

#ifndef _VEC3F_H
#include "Vec3f.h"
#endif

extern float	boxCorners[8][3];
extern float	boxTexCoords[4][2];
extern int	boxIndices[24];

enum BoxHandles {
    TRF = 6, TLF = 5, TRB = 2, TLB = 3, BRF = 7, BLF = 4, BRB = 1, BLB = 0
};

class Util {
public:
    static void	    DrawBox(float sizeX, float sizeY, float sizeZ);
    static Vec3f    IntersectSphere(float x1, float y1, float z1,
				    float x2, float y2, float z2);
    static bool	    IntersectLines(int x1, int y1, int x2, int y2,
				   int x3, int y3, int x4, int y4);
};

#endif // _UTIL_H
