/*
 * x3dtranslators.cpp
 *
 * Copyright (C) 2001 J. "MUFTI" Scheurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 *
 * Additional License - if you need another License 8-) 
  
     Permission is hereby granted, free of charge, to any person obtaining a
     copy of this file, to deal in this file without restriction, including
     without limitation the rights to use, copy, modify, merge, publish,
     distribute, and/or sell copies of this file, and to permit persons
     to whom this file is furnished to do so, provided that the above
     copyright notice(s) and this permission notice appear in all copies of
     this file and that both the above copyright notice(s) and this
     permission notice appear in supporting documentation.

     THIS FILE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
     OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
     MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
     OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
     HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
     INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
     FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
     NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
     WITH THE USE OR PERFORMANCE OF THIS FILE.

     Except as contained in this notice, the name of a copyright holder
     shall not be used in advertising or otherwise to promote the sale, use
     or other dealings in this Software without prior written authorization
     of the copyright holder.
 */

#include "config.h"
#include "swt.h"
#include "DuneApp.h"
#include "x3dtranslators.h"
#include "MyString.h"
#include "mysnprintf.h"

#ifndef WIN32
#include <stdlib.h>
#endif

/* convert VRML97 to x3d via the NIST x3d translators */

bool vrml2x3d(char* path,char* filepath)
{
#ifdef WRITE_XML
   char command[1024*5];
   char dir[1024*2];
   char* java_path;
   getvariable_JAVA_PATH(java_path)
   char* v2x3d_file;
   getvariable_V2X3D_FILE(v2x3d_file)
   char* v2x3d_path;
   getvariable_V2X3D_PATH(v2x3d_path)
   mysnprintf(command,1024*5-1,
              "%s -classpath %s/%s iicm.vrml.vrml2x3d.vrml2x3d %s %s",
              java_path,v2x3d_path,v2x3d_file,path,filepath);            
   mysnprintf(dir,1024*2-1,"%s/test",v2x3d_path);
   if (swShellCommand(TheApp->mainWnd(),java_path,command,".")!=0) 
      {
      char msg[1024];
      sprintf(msg, "convertion to XML of %s failed", path);
      swMessageBox(TheApp->mainWnd(), msg, "Open", SW_MB_OK, SW_MB_WARNING);
      return false;
      }
#endif
   return true;
   }

/* convert x3d to VRML97 via the NIST x3d translators */

#ifndef WIN32
bool x3d2vrml(char* path,char* filepath)
   {
# ifdef READ_XML
   if (swIsXML(filepath)) 
      {
      char* java_path;
      getvariable_JAVA_PATH(java_path)
      char* x3dv2_path;
      getvariable_X3DV2_PATH(x3dv2_path)
      MyString xmldir;
      xmldir=x3dv2_path;
      xmldir+=(char*)"/test/";
      // rather silly copyactions before the translator can be used 8-(
      char tmpdir[2*1024];
      swGetTempPath(tmpdir,"from_xml","",1024);
      char tmpfile[2*1024];
      mystrncpy_secure(tmpfile,tmpdir,1024);
      strncat(tmpfile,"/temp_xml.xml",1024);
      if (swMkdirCommand(TheApp->mainWnd(),tmpdir)!=0) 
         {
         char msg[1024];
         mysnprintf(msg, 1024, "mkdir of %s failed", tmpdir);
         swMessageBox(TheApp->mainWnd(), msg, "Open", SW_MB_OK, SW_MB_WARNING);
         return false;
         }
      if (swCopyCommand(TheApp->mainWnd(),filepath,tmpfile)!=0) 
         {
         char msg[1024];
         mysnprintf(msg, 1024, "copy to %s failed", tmpfile);
         swMessageBox(TheApp->mainWnd(), msg, "Open", SW_MB_OK, SW_MB_WARNING);
         return false;
         }
      MyString xsl="";
      xsl+=xmldir;
      xsl+="X3dToVrml97.xsl";
      if (swCopyCommand(TheApp->mainWnd(),(const char*)xsl,tmpdir)!=0) 
         {
         char msg[1024];
         mysnprintf(msg, 1024, "copy to %s failed", tmpdir);
         swMessageBox(TheApp->mainWnd(), msg, "Open", SW_MB_OK, SW_MB_WARNING);
         return false;
         }
      MyString dtd="";
      dtd+=xmldir;
      dtd+="*.dtd";
      if (swCopyCommand(TheApp->mainWnd(),(const char*)dtd,tmpdir)!=0) 
         {
	 char msg[1024];
         mysnprintf(msg, 1024, "copy to %s failed", tmpdir);
         swMessageBox(TheApp->mainWnd(), msg, "Open", SW_MB_OK, SW_MB_WARNING);
         return false;
         }
      MyString command="";
      char* saxon_path;
      getvariable_SAXON_PATH(saxon_path)
      char* saxon_file;
      getvariable_SAXON_FILE(saxon_file)
      if ((saxon_path!=NULL) && (saxon_file!=NULL))
         {
         command+=java_path;
         command+=" -classpath ";
         command+=saxon_path;
         command+="/";
         command+=saxon_file;
         command+=" com.icl.saxon.StyleSheet ";
         command+=tmpfile;
         command+=" X3dToVrml97.xsl > ";
         command+=path;
         }
      else
         {
         char* x3dv2_file;
         getvariable_X3DV2_FILE(x3dv2_file)
         command+=java_path;
         command+=" -classpath ";
         command+=x3dv2_path;
         command+="/";
         command+=x3dv2_file;
         command+=" org.apache.xalan.xslt.Process -IN ";
         command+=tmpfile;
         command+=" -XSL X3dToVrml97.xsl -OUT ";
         command+=path;
         }
      if (swShellCommand(TheApp->mainWnd(),java_path,
                         (char*)(const char*)command,
                         (char*)tmpdir)!=0) 
         {
         char msg[1024];
         sprintf(msg, "convertion to VRML97 of %s failed", filepath);
         swMessageBox(TheApp->mainWnd(), msg, "Open", SW_MB_OK, SW_MB_WARNING);
         return false;
         }
     }
# endif
  return true;
  }

#else

// there would be no need for a WIN32 version,
// if swShellCommand and friends would work for WIN32...

bool x3d2vrml(char* path,char* filepath)
   {
# ifdef READ_XML
   if (swIsXML(filepath)) 
      {
      char batfile[1024];
      swGetTempPath(batfile,"from_xml",".bat",1024);
      FILE* f=fopen(batfile,"w");
      if (f==NULL)
         return false;
      char* java_path;
      getvariable_JAVA_PATH(java_path)
      char* x3dv2_path;
      getvariable_X3DV2_PATH(x3dv2_path)
      char* x3dv2_file;
      getvariable_X3DV2_FILE(x3dv2_file)
      MyString xmldir;
      xmldir=x3dv2_path;
      xmldir+=(char*)"\\test\\";
      // rather silly copyactions before the translator can be used 8-(
      char tmpdir[1024];
      swGetTempPath(tmpdir,"from_xml","",1024);
      fprintf(f,"IF NOT EXIST %s\\NUL mkdir %s\n",tmpdir,tmpdir);
      fprintf(f,"IF ERRORLEVEL EXIT 1\n");        
      char tmpfile[2*1024];
      mystrncpy_secure(tmpfile,tmpdir,1024);
      strncat(tmpfile,"\\temp_xml.xml",1024);
      fprintf(f,"COPY /Y %s %s\n",filepath,tmpfile);
      fprintf(f,"IF ERRORLEVEL 1 EXIT 1\n");        
      MyString xsl="";
      xsl+=xmldir;
      xsl+="X3dToVrml97.xsl";
      fprintf(f,"COPY /Y %s %s\n",(const char*)xsl,tmpdir);
      fprintf(f,"IF ERRORLEVEL 1 EXIT 1\n");
      MyString dtd="";
      dtd+=xmldir;
      dtd+="*.dtd";
      fprintf(f,"COPY /Y %s %s\n",(const char*)dtd,tmpdir);
      fprintf(f,"IF ERRORLEVEL 1 EXIT 1\n");
      MyString command="";
      char* saxon_path;
      getvariable_SAXON_PATH(saxon_path);
      char* saxon_file;
      getvariable_SAXON_FILE(saxon_file);
      if ((saxon_path!=NULL) && (saxon_file!=NULL))
         {
         command+=java_path;
         command+=" -classpath ";
         command+=saxon_path;
         command+="/";
         command+=saxon_file;
         command+=" com.icl.saxon.StyleSheet ";
         command+=tmpfile;
         command+=" X3dToVrml97.xsl > ";
         command+=path;
         }
      else
         {
         char* x3dv2_file;
         getvariable_X3DV2_FILE(x3dv2_file);
         command+=java_path;
         command+=" -classpath ";
         command+=x3dv2_path;
         command+="/";
         command+=x3dv2_file;
         command+=" org.apache.xalan.xslt.Process -IN ";
         command+=tmpfile;
         command+=" -XSL X3dToVrml97.xsl -OUT ";
         command+=path;
         }
      fprintf(f,"%c%c\n",tmpdir[0],tmpdir[1]);
      fprintf(f,"IF ERRORLEVEL 1 EXIT 1\n");
      fprintf(f,"cd %s\n",tmpdir);
      fprintf(f,"IF ERRORLEVEL 1 EXIT 1\n");
      fprintf(f,"%s\n",(const char*)command);
      fprintf(f,"IF ERRORLEVEL 1 EXIT 1\n");
      fclose(f);
      if (swShellCommand(TheApp->mainWnd(),java_path,batfile,"")!=0) 
         {
		 char	msg[1024];
	     sprintf(msg, "convertion to VRML97 of %s failed", filepath);

	     swMessageBox(TheApp->mainWnd(), msg, "Open", SW_MB_OK, SW_MB_WARNING);
         return false;
		 }
      }
# endif
   return true;
   }

#endif

