
-- white_dune-Launcher for new Apple X11
-- this file can be used to start white_dune with commandline parameters

-- * This program is free software; you can redistribute it and/or modify
-- * it under the terms of the GNU General Public License as published by
-- * the Free Software Foundation; either version 2 of the License, or
-- * (at your option) any later version.

-- Made with the help from Markus Schneider and Martin Briegel

-- this is a applescript program, that starts a unix commandline with a program
-- in errorcase, it starts a unix commandline with the start of the applescript interpreter
-- to let start the MacOSX application Finder to display a message

on open droppedFiles
	my ProcessFiles(droppedFiles)
end open

on ProcessFiles(rawFiles)
	set theFiles to {}
	set dunepath to "$DUNE_PATH/$DUNE" as string
	-- insert various additional parameters here
	set addparms to "$ADDPARAMS"
	-- spaceball on bluetooth to serial adapter
	--  set addparms to "-nostereo -spaceball /dev/tty.pico -all=2,5,,0.0000002" as string
	-- set debugopts to "2>&1 >>~/.dune.log" as string 
	set debugopts to ""
	set errormsg to " ;ERROR=$?;if test $ERROR = 11 ; then osascript -l AppleScript -e 'tell Application \"Finder\" to display dialog \"unable to start X11 Application. Is X11 for MacOSX installed at /Applications/X11.app/Contents/MacOS/X11 ?\" ' ; fi "
	
	
	repeat with i from 1 to the count of rawFiles
		set theFiles to theFiles & POSIX path of (item i of rawFiles as alias) & " "
	end repeat
	
	set shellcall to dunepath & " -display localhost:0 " & addparms & " " & theFiles & " " & debugopts & " " & errormsg & " & " as string
	--	display dialog shellcall
	
	do shell script shellcall
	
end ProcessFiles

on launched theObject
	my ProcessFiles({})
end launched

