# Copyright 1999-2003 Gentoo Technologies, Inc.
# Distributed under the terms of the GNU General Public License v2
#
# J. "MUFTI" Scheurich (tips from Torben Hohn)


S=${WORKDIR}/${P}
DESCRIPTION="graphical VRML editor and animation tool"
SRC_URI=`echo http://www.csv.ica.uni-stuttgart.de/vrml/dune/${PN}-${PV}.tar.gz | awk '{gsub(".tar.gz","-gentoo.tar.gz");print $0}'`
HOMEPAGE="http://www.csv.ica.uni-stuttgart.de/vrml/dune"
KEYWORDS="x86 ppc sparc sparc64"
SLOT="0"
LICENSE="GPL-2"
IUSE=""
DEPEND="media-libs/libpng
        media-libs/jpeg                   
        sys-libs/zlib 
        virtual/opengl 
        virtual/glu 
        virtual/glut
        virtual/x11
        virtual/motif
        virtual/glibc"

src_compile() {
        cd $S
	local myconf
	myconf="--with-optimization --with-buginlesstif --without-devil --with-vrmlbrowser=mozilla --with-helpurl=/usr/share/doc/${P}/docs/ --with-nurbscurveprotourl=/usr/share/misc/white_dune/NurbsCurvePROTO.wrl --with-nurbsgroupprotourl=/usr/share/misc/white_dune/NurbsGroupPROTO.wrl --with-nurbssurfaceprotourl=/usr/share/misc/white_dune/NurbsSurfacePROTO.wrl"
	econf ${myconf} || die "configure failure" 
	emake || die "make failure"
}

src_install() {
        exeinto /usr/bin 
        doexe bin/dune
        doexe bin/dune4kids

        doman man/dune.1
	dodoc docs COPYING README README.x3dtranslators INSTALL TODO
        cp -R docs ${D}/usr/share/doc/${PF}
}
