/*
 * DuneApp.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

// data global to the whole application

#ifndef _DUNE_APP_H
#define _DUNE_APP_H

#ifndef _LIST_H
#include "List.h"
#endif
#ifndef _ARRAY_H
#include "Array.h"
#endif
#ifndef _DUNE_STRING_H
#include "MyString.h"
#endif
#ifndef _NODE_H
#include "Node.h"
#endif
#ifndef _URL_H
#include "URL.h"
#endif
#ifndef _PREFERENCES_APP_H
#include "PreferencesApp.h"
#endif
#ifndef _STEREO_VIEW_APP_H
#include "StereoViewApp.h"
#endif
#ifndef _INPUT_DEVICE_APP_H
#include "InputDeviceApp.h"
#endif

class Scene;
class MainWindow;

class FileBackup { 
public:
   			FileBackup(char* backupFile, URL url, const char* path);

   char 	       *_backupFile;
   URL 			_url;
   char* 		_path;
};       

class DuneApp : public PreferencesApp, 
                public StereoViewApp, 
                public InputDeviceApp {
public:
			DuneApp();

    // file menu
    void		newMainWnd(SWND &mainWnd);
    void		OnFileNew();
    void                OnFileNewWindow();
    void 		OnFilePreview(Scene* scene);
    void		OnFileEdit(MainWindow *window, Scene* oldscene,
                                   char* filename=NULL);
    void		OnFileClose(MainWindow *window);
    void		OnFileExit();

    bool		ImportFile(const char *openpath, Scene* scene);
    bool		OpenFile(const char *path);

    bool                checkSaveOldWindow(void);
    void                deleteOldWindow(void);

    // recent files in File menu 
    int			GetNumRecentFiles() const;
    const MyString     &GetRecentFile(int index) const;
    void		AddToRecentFiles(const MyString &filename);
    void		SaveRecentFileList(void);

    int 		emergency_rescue(void);


    SBROWSER		GetBrowser() const { return _browser; }
    SHBROWSER		GetHelpBrowser() const { return _helpBrowser; }
    STEXTEDIT		GetTextedit() const { return _textedit; }

    Node               *getClipboardNode(void) {return _clipboardNode;}
    void 		setClipboardNode(Node* node) {_clipboardNode=node;}

    SWND		mainWnd(void) {return _mainWnd;}

    void		PrintMessageWindows(const char *text);

    void 		AddToFilesToDelete(char* string); 

    const char 	       *getImportURL(void) { return _importURL; }
    void	    	setImportURL(const char* newURL) { _importURL=newURL; }

    void		initSelectionLinenumber(void); 
    void		checkSelectionLinenumberCounting(Scene* scene, 
                                                         Node* node);
    void		incSelectionLinenumber(int increment = 1);
    int			getSelectionLinenumber(void);

    bool		saveTempFiles(MainWindow *currentWindow, 
                                      int useExtensionTxt);
    void		restoreTempFiles(void);

    void		UpdateAllWindows(void);

    List<MainWindow *>	getWindows(void) { return _windows; }

protected:
    void		Exit(void);

protected:
    List<MainWindow *>	_windows;
    Array<MyString>	_recentFiles;

    SBROWSER		_browser;
    SHBROWSER		_helpBrowser;
    STEXTEDIT		_textedit;

    SWND		_mainWnd;
    Node	       *_clipboardNode;

    Array<MyString*>    _filesToDelete;

    const char*		_importURL;

    int			_selectionLinenumber;
    bool		_selectionLinenumberFlag;

    List<FileBackup *>  _tempFiles;

private:
    MainWindow         *_currentWindow;
 
};

extern DuneApp *TheApp;

#endif // _DUNE_APP_H
