/*
 * MFNode.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "stdafx.h"

#include "MFNode.h"
#include "SFNode.h"
#include "Node.h"
#include "DuneApp.h"

MFNode::MFNode()
{
    _value = new NodeList();
}

MFNode::MFNode(const MFNode &other)
{
    int		size = other._value->size();

    _value = new NodeList();
    for (int i = 0; i < size; i++) {
	_value->set(i, other._value->get(i)->copy());
	_value->get(i)->ref();
        _value->get(i)->reInit();
    }
}

MFNode::MFNode(NodeList *value)
{
    _value = value;
    for (int i = 0; i < _value->size(); i++)
	_value->get(i)->ref();
}

MFNode::~MFNode()
{
    for (int i = 0; i < _value->size(); i++)
	_value->get(i)->unref();
    delete _value;
}

int MFNode::write(int f, int indent) const
{
#ifndef HAVE_KR_LIKE_INDENT
    RET_ONERROR( mywritestr(f, "\n") )
    TheApp->incSelectionLinenumber();
    RET_ONERROR( indentf(f, indent+2) )
#endif
    RET_ONERROR( mywritestr(f, "[\n") )
    TheApp->incSelectionLinenumber();
    for (int i = 0; i < _value->size(); i++) {
	RET_ONERROR( _value->get(i)->write(f, indent + 2) )
    }
#ifndef HAVE_KR_LIKE_INDENT
    RET_ONERROR( indentf(f, indent+2) )
#else
    RET_ONERROR( indentf(f, indent) )
#endif
    RET_ONERROR( mywritestr(f, "]\n") )
    TheApp->incSelectionLinenumber();
    return(0);
}

bool
MFNode::equals(const FieldValue *value) const
{
    if (value->getType() == MFNODE) {
	NodeList	*v = ((MFNode *) value)->getValues();
	if (v->size() != _value->size()) return false;
	for (int i = 0; i < _value->size(); i++)
	    if (v->get(i) != _value->get(i)) return false;
	return true;
    }
    return false;
}

FieldValue *
MFNode::addNode(Node *node) const
{
    NodeList    *list = new NodeList();
    for (int i = 0; i < _value->size(); i++) {
	list->append(_value->get(i));
    }
    list->append(node);
    return new MFNode(list);
}

FieldValue *
MFNode::removeNode(Node *node) const
{
    NodeList    *list = new NodeList();

    for (int i = 0; i < _value->size(); i++) {
	if (_value->get(i) != node) list->append(_value->get(i));
    }
    return new MFNode(list);
}

FieldValue *
MFNode::getSFValue(int index) const
{
    return new SFNode(_value->get(index));
}

void
MFNode::setSFValue(int index, FieldValue *value)
{
    _value[index] = ((SFNode *) value)->getValue();
}


MyString
MFNode::getEcmaScriptComment(MyString name, int flags) const
{
    const char *indent = ((FieldValue *)this)->getEcmaScriptIndent(flags);
    MyString ret;
    ret = "";
    if (TheApp->GetEcmaScriptAddAllowedValues()) {
        ret += indent;
        ret += "// allowed values:\n";

        ret += indent;
        ret += "   // array ([0] [1] [2] ...) of VRML node objects\n";
    }
    if (TheApp->GetEcmaScriptAddAllowedComponents()) {
        ret += indent;
        ret += "// allowed components:\n";

        ret += indent;
        ret += "   // depends from type of node: ";
        ret += name;
        ret += "[???].eventin_of_node or ";
        ret += name;
        ret += "[???].eventout_of_node\n";
    }
    if (TheApp->GetEcmaScriptAddAvailableFunctions()) {
        ret += indent;
        ret += "// available functions:\n";
        if (flags != EL_EVENT_IN) {
            ret += indent;
            ret += "   // ";
            ret += name;
            ret += " = new MFNode(sfnode_n1, sfnode_n2, ...);\n";
        }
        if (flags != EL_EVENT_OUT) {
            ret += indent;
            ret += "   // int_i = ";
            ret += name;
            ret += ".length();\n";

            ret += indent;
            ret += "   // string_str = ";
            ret += name;
            ret += ".toString();\n";
        }
    }
    if (TheApp->GetEcmaScriptAddBrowserObject()) {
        ret += indent;
        ret += "// related Browser Object functions:\n";
        if (flags != EL_EVENT_IN) {
            ret += indent;
            ret += "   // ";
            ret += name;
            ret += " = Browser.createVrmlFromString(string_vrmlsyntax);\n";
        }
        if (flags != EL_EVENT_OUT) {
            ret += indent;
            ret += "   // Browser.replaceWorld(";
            ret += name;
            ret += ");\n";

            ret += indent;
            ret += "   // Browser.loadURL(";
            ret += name;
            ret += ", mfstring_parameter);\n";
        }
    }
    if (TheApp->GetEcmaScriptAddExampleUsage()) {
        ret += indent;
        ret += "// example usage:\n";
        if (flags != EL_EVENT_IN) {
             ret += indent;
             ret += "   // ";
             ret += name;
             ret += " = Browser.createVrmlFromString('Shape {geometry Text {string \\\"A\\\"}} SpotLight {}');\n";

             ret += indent;
             ret += "   // ";
             ret += name;
             ret += "[0].geometry.string = 'hello';\n";
        } 
        if (flags != EL_EVENT_OUT) {
             ret += indent;
             ret += "   // string_str =";
             ret += name;
             ret += ".toString();\n";
        }
    }
    return ret;
}
