/*
 * Mesh.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _MESH_H
#define _MESH_H

#ifndef _ARRAY_H
#include "Array.h"
#endif

#ifndef _VEC3F_H
#include "Vec3f.h"
#endif

#ifndef _VEC2F_H
#include "Vec2f.h"
#endif

class Face;
class MFColor;
class MFVec3f;
class MFVec2f;
class MFInt32;

class Mesh {
public:
			Mesh(MFVec3f *vertices, MFInt32 *coordIndex,
			     MFVec3f *normals, MFInt32 *normalIndex,
			     MFColor *colors, MFInt32 *colorIndex,
			     MFVec2f *texCoords, MFInt32 *texCoordIndex,
			     float creaseAngle, bool ccw, bool solid, 
                             bool normalPerVertex);
		       ~Mesh();
		
    void		draw();
    void		sort();

    MFVec3f	       *getVertices(void)      { return _vertices; }
    MFInt32	       *getCoordIndex(void)    { return _coordIndex; }
    MFVec3f	       *getNormals(void)       { return _normals; }
    MFInt32	       *getNormalIndex(void)   { return _normalIndex; }
    MFVec2f	       *getTexCoords(void)     { return _texCoords; }
    MFInt32	       *getTexCoordIndex(void) { return _texCoordIndex; }


protected:
    void		buildFaces();
    void		generateFaceNormals();
    void		smoothNormals();
 
private:
    MFVec3f	       *_vertices;
    MFVec3f	       *_normals;
    MFColor	       *_colors;
    MFVec2f	       *_texCoords;

    MFInt32	       *_coordIndex;
    MFInt32	       *_normalIndex;
    MFInt32	       *_colorIndex;
    MFInt32	       *_texCoordIndex;

    int			_numFaces;
    Face	      **_faces;

    float		_creaseAngle;
    bool		_ccw;
    bool		_solid;
    bool                _normalPerVertex;
};

#endif // _MESH_H
