/*
 * NodeAppearance.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "stdafx.h"

#include "NodeAppearance.h"
#include "Proto.h"
#include "FieldValue.h"
#include "SFFloat.h"
#include "SFNode.h"
#include "Node.h"
#include "NodeMaterial.h"

ProtoAppearance::ProtoAppearance(Scene *scene)
  : Proto(scene, "Appearance")
{
    material.set(
          addExposedField(SFNODE, "material", new SFNode(NULL), NODE_MATERIAL));
    texture.set(
          addExposedField(SFNODE, "texture", new SFNode(NULL), NODE_TEXTURE));
    textureTransform.set(
          addExposedField(SFNODE, "textureTransform", new SFNode(NULL), 
                          NODE_TEXTURE_TRANSFORM));
}

Node *
ProtoAppearance::create(Scene *scene)
{ 
    return new NodeAppearance(scene, this); 
}

NodeAppearance::NodeAppearance(Scene *scene, Proto *def)
  : Node(scene, def)
{
}

void NodeAppearance::bind()
{
    Node    *nMaterial = ((SFNode *) getField(material_Index(),
                                             true))->getValue();
    Node    *nTexture = ((SFNode *) getField(texture_Index(),true))->getValue();
    Node    *nTextureTransform = ((SFNode *) getField(textureTransform_Index(),
                                                     true))->getValue();
    float    ftransparency = 0.0f;

    if (nMaterial) {
	nMaterial->bind();
        ftransparency = ((NodeMaterial *) nMaterial)->transparency()->getValue();
    }
    if (nTexture) {
	nTexture->bind();
	// ignore material's diffuse component for components > 2
	// FIXME:  right now we ignore for all textures
	float dc[4];
	dc[0] = dc[1] = dc[2] = 1.0f;  dc[3] = 1.0f - ftransparency;
	glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, dc);
    }
    if (nTextureTransform) nTextureTransform->bind();
}

void NodeAppearance::unbind()
{
    Node    *nMaterial = ((SFNode *) getField(material_Index(),
                                             true))->getValue();
    Node    *nTexture = ((SFNode *) getField(texture_Index(),true))->getValue();
    Node    *nTextureTransform = ((SFNode *) getField(textureTransform_Index(),
                                                     true))->getValue();

    if (nMaterial) nMaterial->unbind();
    if (nTexture) nTexture->unbind();
    if (nTextureTransform) nTextureTransform->unbind();
}
