/*
 * NodeGroup.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "stdafx.h"

#include "NodeGroup.h"
#include "Proto.h"
#include "FieldValue.h"
#include "MFNode.h"
#include "SFVec3f.h"
#include "SFFloat.h"
#include "NodeNurbsGroup.h"
#include "Scene.h"

ProtoGroup::ProtoGroup(Scene *scene, const char *name)
  : Proto(scene, name)
{
     addElements(); 
}

ProtoGroup::ProtoGroup(Scene *scene)
  : Proto(scene, "Group")
{                    
     addElements();     
}

void ProtoGroup::addElements(void) 
{
    addEventIn(MFNODE, "addChildren");
    addEventIn(MFNODE, "removeChildren");
    children.set(
          addExposedField(MFNODE, "children", new MFNode(), NODE_CHILD));
    bboxCenter.set(
          addField(SFVEC3F, "bboxCenter", new SFVec3f(0.0f, 0.0f, 0.0f)));
    bboxSize.set(
          addField(SFVEC3F, "bboxSize", new SFVec3f(-1.0f, -1.0f, -1.0f), 
	           new SFFloat(-1.0f)));
}

Node *
ProtoGroup::create(Scene *scene)
{ 
    return new NodeGroup(scene, this); 
}

NodeGroup::NodeGroup(Scene *scene, Proto *def)
  : Node(scene, def)
{
}

NodeGroup::NodeGroup(NodeNurbsGroup *nurbsGroup)
  : Node(nurbsGroup->getScene(), nurbsGroup->getScene()->getProto("Group"))
{
    children(nurbsGroup->children());
    bboxCenter(nurbsGroup->bboxCenter());
    bboxSize(nurbsGroup->bboxSize());
}

void
NodeGroup::draw()
{
    int		i;
    NodeList   *childList = children()->getValues();

    glPushName(children_Index());	// field offset

    for (i = 0; i < childList->size(); i++)
	childList->get(i)->bind();

    glPushName(0);
    for (i = 0; i < childList->size(); i++) {
	glLoadName(i);
	childList->get(i)->draw();
    }
    glPopName();

    for (i = 0; i < childList->size(); i++)
	childList->get(i)->unbind();

    glPopName();
}

void
NodeGroup::preDraw()
{
    NodeList    *childList = children()->getValues();

    for (int i = 0; i < childList->size(); i++)
	childList->get(i)->preDraw();
}
