/*
 * NodeMaterial.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _NODE_MATERIAL_H
#define _NODE_MATERIAL_H

#ifndef _NODE_H
#include "Node.h"
#endif
#ifndef _PROTO_MACROS_H
#include "ProtoMacros.h"
#endif
#ifndef _PROTO_H
#include "Proto.h"
#endif

#include "SFMFTypes.h"

class ProtoMaterial : public Proto {
public:
		    ProtoMaterial(Scene *scene);
    virtual Node   *create(Scene *scene);

    FieldIndex ambientIntensity;
    FieldIndex diffuseColor;
    FieldIndex emissiveColor;
    FieldIndex shininess;
    FieldIndex specularColor;
    FieldIndex transparency;
};

class NodeMaterial : public Node {
public:
		    NodeMaterial(Scene *scene, Proto *proto);

    virtual int	    getType() const { return NODE_MATERIAL; }
    virtual Node   *copy() const { return new NodeMaterial(*this); }
    virtual int	    getNodeClass() const { return NODE_MATERIAL; }
    virtual void    bind();
    virtual void    unbind();
    
    fieldMacros(SFFloat, ambientIntensity, ProtoMaterial)
    fieldMacros(SFColor, diffuseColor,     ProtoMaterial)
    fieldMacros(SFColor, emissiveColor,    ProtoMaterial)
    fieldMacros(SFFloat, shininess,        ProtoMaterial)
    fieldMacros(SFColor, specularColor,    ProtoMaterial)
    fieldMacros(SFFloat, transparency,     ProtoMaterial)

};

#endif // _NODE_MATERIAL_H
