/*
 * NodeNurbsCurve.h
 *
 * Copyright (C) 2003 Th. Rothermel
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _NODE_NURBS_CURVE_H
#define _NODE_NURBS_CURVE_H

#ifndef _NODE_H
#include "Node.h"
#endif
#ifndef _PROTO_MACROS_H
#include "ProtoMacros.h"
#endif
#ifndef _PROTO_H
#include "Proto.h"
#endif
#ifndef _VEC3F_H
#include "Vec3f.h"
#endif
#ifndef _SFMFTYPES_H
#include "SFMFTypes.h"
#endif

#include "NodeIndexedLineSet.h"

typedef enum {
NURBS_ROT_X_AXIS,
NURBS_ROT_Y_AXIS,
NURBS_ROT_Z_AXIS,
NURBS_ROT_POINT_TO_POINT
} NurbsRot;

#define MFDouble MFFloat
#define MFDOUBLE MFFLOAT

class ProtoNurbsCurve : public Proto {
public:
		    ProtoNurbsCurve(Scene *scene);
    virtual Node   *create(Scene *scene);

    FieldIndex controlPoint;
    FieldIndex tessellation;
    FieldIndex weight;
    FieldIndex knot;
    FieldIndex order;
};

class NodeNurbsCurve : public Node {
public:
		    NodeNurbsCurve(Scene *scene, Proto *proto);

    virtual int	    getType() const { return NODE_NURBS_CURVE; }
    virtual Node   *copy() const { return new NodeNurbsCurve(*this); }
    virtual int	    getNodeClass() const { return NODE_NURBS_GEOMETRY; }

    virtual void    draw();
    virtual void    drawHandles();

    virtual Vec3f   getHandle(int handle, int *constraint, int *field);
    virtual void    setHandle(int handle, const Vec3f &v);

    virtual void    setField(int index, FieldValue *value);

    bool    	    writeEXTERNPROTO(int filedes);
    int		    write(int filedes, int indent);

    bool            flatten(int direction);
    void            flatter(int zero, int change);

    Node           *toIndexedLineSet(void);
    virtual Node   *toNurbs(int narcs, int pDegree, float rDegree, Vec3f &P1, Vec3f &P2);

    void            update(void) { _chainDirty = true; }
    void            reInit(void) { _chain.resize(0); _chainDirty = true; }

    fieldMacros(MFVec3f,   controlPoint,  ProtoNurbsCurve)
    fieldMacros(SFInt32,   tessellation,  ProtoNurbsCurve)
    fieldMacros(MFDouble,  weight,        ProtoNurbsCurve)
    fieldMacros(MFDouble,  knot,          ProtoNurbsCurve)
    fieldMacros(SFInt32,   order,         ProtoNurbsCurve)


protected:
    void	    createChain();
    static int	    findSpan(int dimension, int order, float u,
    			     const float knots[]);
    static void     basisFuns(int span, float u, int order,
    			      const float knots[], float basis[],
			      float deriv[]);
    static Vec3f    curvePoint(int dimension, int order, 
			       const float knots[],
			       const Vec3f controlPoints[],
			       const float weight[], float u);
    //Node           *toNurbs(int narcs, int pDegree, float rDegree, Vec3f &P1, Vec3f &P2);

private:
    int             _dimension;
    Array<Vec3f>    _chain;
    bool	    _chainDirty;
};





#endif // _NODE_NURBS_CURVE_H
