/*
 * NodeViewpoint.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _NODE_VIEWPOINT_H
#define _NODE_VIEWPOINT_H

#ifndef _NODE_H
#include "Node.h"
#endif
#ifndef _PROTO_MACROS_H
#include "ProtoMacros.h"
#endif
#ifndef _PROTO_H
#include "Proto.h"
#endif
#ifndef _QUATERNION_H
#include "Quaternion.h"
#endif
#ifndef _VEC3F_H
#include "Vec3f.h"
#endif

#include "SFMFTypes.h"

class ProtoViewpoint : public Proto {
public:
			ProtoViewpoint(Scene *scene);
    virtual Node       *create(Scene *scene);

    FieldIndex fieldOfView;
    FieldIndex jump;
    FieldIndex orientation;
    FieldIndex position;
    FieldIndex description;
};


class NodeViewpoint : public Node {
public:
			NodeViewpoint(Scene *scene, Proto *proto);

    virtual int		getType() const { return NODE_VIEWPOINT; }
    virtual Node       *copy() const { return new NodeViewpoint(*this); }

    virtual void	preDraw();
    void		apply();

    Vec3f		getPosition() const;
    const Quaternion   &getOrientation() const;

    void		setPosition(const Vec3f &pos);
    void		setOrientation(const Quaternion &quat);

    fieldMacros(SFFloat,    fieldOfView, ProtoViewpoint)
    fieldMacros(SFBool,     jump,        ProtoViewpoint)
    fieldMacros(SFRotation, orientation, ProtoViewpoint)
    fieldMacros(SFVec3f,    position,    ProtoViewpoint)
    fieldMacros(SFString,   description, ProtoViewpoint)
protected:
    float		_matrix[16];
};

#endif // _NODE_VIEWPOINT_H
