/*
 * PreferencesApp.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include "swt.h"
#include "PreferencesApp.h"
#include "DuneApp.h"

PreferencesApp::PreferencesApp()
{
    _prefs = swLoadPreferences("DuneSoft", "dune");
    _showAllFields = GetBoolPreference("ShowAllFields", false);
    _rotationOrder = GetIntPreference("RotationOrder", EulOrdXYZs);
    _rotationTitle = "XYZs";
    _handleMode = (HandleMode) GetIntPreference("HandleMode", HM_SELECTED);
    const char* handleSizeBuf        = GetPreference("HandleSize", "2.0");
    _handleSize = atof(handleSizeBuf);
    _ecmaScriptAddInitialise         = GetBoolPreference(
                                       "EcmaScriptAddInitialise", true);
    _ecmaScriptAddShutdown           = GetBoolPreference(
                                       "EcmaScriptAddShutdown", false);
    _ecmaScriptAddEventsProcessed    = GetBoolPreference(
                                       "EcmaScriptAddEventsProcessed",  false);
    _ecmaScriptAddAvailableFunctions = GetBoolPreference(
                                       "EcmaScriptAddAvailableFunctions", true);
    _ecmaScriptAddAllowedValues      = GetBoolPreference(
                                       "EcmaScriptAddAllowedValues", true);
    _ecmaScriptAddAllowedComponents  = GetBoolPreference(
                                       "EcmaScriptAddAllowedComponents", true);
    _ecmaScriptAddExampleUsage       = GetBoolPreference(
                                       "EcmaScriptAddExampleUsage", true);
    _ecmaScriptAddMathObject         = GetBoolPreference(
                                       "EcmaScriptAddMathObject", true);
    _ecmaScriptAddBrowserObject      = GetBoolPreference(
                                       "EcmaScriptAddBrowserObject", true);
    const char* epsilonBuf           = GetPreference("Epsilon", "0.005");
    _epsilon = atof(epsilonBuf);
}

void PreferencesApp::SavePreferences()
{
    char buf[128];
    SetBoolPreference("ShowAllFields", _showAllFields);
    SetIntPreference("RotationOrder", _rotationOrder);
    SetIntPreference("HandleMode", _handleMode);
    snprintf(buf,127,"%f",_handleSize);
    SetPreference("HandleSize", buf);
    SetBoolPreference("EcmaScriptAddInitialise",
                      _ecmaScriptAddInitialise);
    SetBoolPreference("EcmaScriptAddShutdown",
                      _ecmaScriptAddShutdown);
    SetBoolPreference("EcmaScriptAddEventsProcessed",
                      _ecmaScriptAddEventsProcessed);
    SetBoolPreference("EcmaScriptAddAvailableFunctions",
                      _ecmaScriptAddAvailableFunctions);
    SetBoolPreference("EcmaScriptAddAllowedValues",
                      _ecmaScriptAddAllowedValues);
    SetBoolPreference("EcmaScriptAddAllowedComponents",
                      _ecmaScriptAddAllowedComponents);
    SetBoolPreference("EcmaScriptAddExampleUsage",
                      _ecmaScriptAddExampleUsage);
    SetBoolPreference("EcmaScriptAddMathObject",
                      _ecmaScriptAddMathObject);
    SetBoolPreference("EcmaScriptAddBrowserObject", 
                      _ecmaScriptAddBrowserObject);
    snprintf(buf,127,"%f",_epsilon);
    SetPreference("Epsilon", buf);

    TheApp->StereoViewSavePreferences();
    
    swSavePreferences(_prefs);
}

void PreferencesApp::SetShowAllFields(bool showAllFields)
{
    if (_showAllFields != showAllFields) {
	_showAllFields = showAllFields;
	TheApp->UpdateAllWindows();
    }
}

void PreferencesApp::SetRotationOrder(int rotationOrder)
{
    if (_rotationOrder != rotationOrder) {
	_rotationOrder = rotationOrder;
	TheApp->UpdateAllWindows();
    }
}

float PreferencesApp::GetHandleSize(void)
{
    if (TheApp->canStereo() && TheApp->useStereo())
        return TheApp->GetStereoHandleSizeMult() * _handleSize;
    else
        return _handleSize;         
}

void PreferencesApp::SetHandleSize(float size)
{
    _handleSize = size;         
    TheApp->UpdateAllWindows();
}

void PreferencesApp::SetHandleMode(HandleMode handleMode)
{
    if (_handleMode != handleMode) {
	_handleMode = handleMode;
	TheApp->UpdateAllWindows();
    }
}

bool
PreferencesApp::GetBoolPreference(const char *key, bool defaultValue)
{
    return swGetIntPreference(_prefs, key, defaultValue) != 0;
}

int
PreferencesApp::GetIntPreference(const char *key, int defaultValue)
{
    return swGetIntPreference(_prefs, key, defaultValue);
}

const char *
PreferencesApp::GetPreference(const char *key, const char *defaultValue)
{
    return swGetPreference(_prefs, key, defaultValue);
}

void
PreferencesApp::SetBoolPreference(const char *key, bool value)
{
    swSetIntPreference(_prefs, key, value ? 1 : 0);
}

void
PreferencesApp::SetIntPreference(const char *key, int value)
{
    swSetIntPreference(_prefs, key, value);
}

void
PreferencesApp::SetPreference(const char *key, const char *value)
{
    swSetPreference(_prefs, key, value);
}


