/*
 * PreferencesDialog.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include "stdafx.h"
#include "PreferencesDialog.h"
#include "DuneApp.h"
#include "resource.h"
#include "swt.h"
#include "EulerAngles.h"

static int rot[24] = {
    EulOrdXYZs, EulOrdXYXs, EulOrdXZYs, EulOrdXZXs, 
    EulOrdYZXs, EulOrdYZYs, EulOrdYXZs, EulOrdYXYs,
    EulOrdZXYs, EulOrdZXZs, EulOrdZYXs, EulOrdZYZs,

    EulOrdZYXr, EulOrdXYXr, EulOrdYZXr, EulOrdXZXr,
    EulOrdXZYr, EulOrdYZYr, EulOrdZXYr, EulOrdYXYr,
    EulOrdYXZr, EulOrdZXZr, EulOrdXYZr, EulOrdZYZr 
};

static const char *rotTitles[24] = { 
    "XYZs", "XYXs", "XZYs", "XZXs",
    "YZXs", "YZYs", "YXZs", "YXYs",
    "ZXYs", "ZXZs", "ZYXs", "ZYZs",

    "ZYXr", "XYXr", "YZXr", "XZXr",
    "XZYr", "YZYr", "ZXYr", "YXYr",
    "YXZr", "ZXZr", "XYZr", "ZYZr"
};

PreferencesDialog::PreferencesDialog(SWND parent)
  : Dialog(parent, IDD_PREFERENCES)
{
    LoadData();
}

void PreferencesDialog::LoadData()
{
    char        buf[128];
    int	    handleMode = TheApp->GetHandleMode();
    swSetCheck(swGetDialogItem(_dlg, IDC_HANDLES_NONE),
    	       handleMode == HM_NONE);
    swSetCheck(swGetDialogItem(_dlg, IDC_HANDLES_SELECTED),
    	       handleMode == HM_SELECTED);
    swSetCheck(swGetDialogItem(_dlg, IDC_HANDLES_TREE),
    	       handleMode == HM_TREE);
    swSetCheck(swGetDialogItem(_dlg, IDC_HANDLES_ALL),
    	       handleMode == HM_ALL);
    swSetCheck(swGetDialogItem(_dlg, IDC_SHOW_ALL_FIELDS),
    	       TheApp->GetShowAllFields());
    snprintf(buf, 128, "%f", TheApp->GetHandleSize());
    swSetText(swGetDialogItem(_dlg, IDC_HANDLE_SIZE), buf);
    SWND combo = swGetDialogItem(_dlg, IDC_ROTATION_ORDER);
    swComboBoxDeleteAll(combo);
    for (int i = 0; i < 24; i++) {
	swComboBoxAppendItem(combo, rotTitles[i]);
	if (rot[i] == TheApp->GetRotationOrder()) {
	    swComboBoxSetSelection(combo, i);
	}
    }
    snprintf(buf, 128, "%f", TheApp->GetEpsilon());
    swSetText(swGetDialogItem(_dlg, IDC_EPSILON), buf);
}

void
PreferencesDialog::SaveData() 
{
    HandleMode		handleMode;
    SWND	    	saf;
    char buf[128];

    if (swGetCheck(swGetDialogItem(_dlg, IDC_HANDLES_NONE))) {
	handleMode = HM_NONE;
    } else if (swGetCheck(swGetDialogItem(_dlg, IDC_HANDLES_SELECTED))) {
	handleMode = HM_SELECTED;
    } else if (swGetCheck(swGetDialogItem(_dlg, IDC_HANDLES_TREE))) {
	handleMode = HM_TREE;
    } else if (swGetCheck(swGetDialogItem(_dlg, IDC_HANDLES_ALL))) {
	handleMode = HM_ALL;
    }
    TheApp->SetHandleMode(handleMode);
    swGetText(swGetDialogItem(_dlg, IDC_HANDLE_SIZE), buf, 128);
    TheApp->SetHandleSize(atof(buf));    
    saf = swGetDialogItem(_dlg, IDC_SHOW_ALL_FIELDS);
    TheApp->SetShowAllFields(swGetCheck(saf) != FALSE);
    int	    sel = swComboBoxGetSelection(swGetDialogItem(_dlg, IDC_ROTATION_ORDER));
    TheApp->SetRotationOrder(rot[sel]);
    TheApp->SetRotationTitle(rotTitles[sel]);
    swGetText(swGetDialogItem(_dlg, IDC_EPSILON), buf, 128);
    TheApp->SetEpsilon(atof(buf));
}
