/*
 * PreviewSettingsDialog.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include "stdafx.h"
#include "PreviewSettingsDialog.h"
#include "DuneApp.h"
#include "resource.h"
#include <swt.h>

PreviewSettingsDialog::PreviewSettingsDialog(SWND parent)
  : Dialog(parent, IDD_PREVIEW_SETTINGS)
{
    LoadData();
}

void
PreviewSettingsDialog::OnCommand(int id)
{
    switch(id) {
      case IDC_BROWSE:
	OnBrowse();
	break;
      case IDC_USE_REMOTE:
	OnUseRemote();
	break;
      default:
	Dialog::OnCommand(id);
	break;
    }
}

static MyString
GetText(SWND item)
{
    char	buf[1024];
    swGetText(item, buf, 1024);
    return buf;
}

void PreviewSettingsDialog::LoadData()
{
    const char *command;
    int		pureVRML97;
    int		useRemote;
    const char *remoteCommand;
    const char *application;
    const char *topic;

    swBrowserGetSettings(TheApp->GetBrowser(), &command, 
                         &pureVRML97, &useRemote, 
    			 &remoteCommand, &application, &topic);

    swSetText(swGetDialogItem(_dlg, IDC_COMMAND), command);
    swSetCheck(swGetDialogItem(_dlg, IDC_USE_REMOTE), useRemote);
    swSetCheck(swGetDialogItem(_dlg, IDC_BROWSER_VRML97), pureVRML97);
    swSetText(swGetDialogItem(_dlg, IDC_REMOTE_COMMAND), remoteCommand);
    swSetText(swGetDialogItem(_dlg, IDC_APPLICATION), application);
    swSetText(swGetDialogItem(_dlg, IDC_TOPIC), topic);
}

void
PreviewSettingsDialog::SaveData()
{
    MyString	command;
    int         pureVRML97;
    int		useRemote;
    MyString	remoteCommand;
    MyString	application;
    MyString	topic;

    command = GetText(swGetDialogItem(_dlg, IDC_COMMAND));
    useRemote = swGetCheck(swGetDialogItem(_dlg, IDC_USE_REMOTE));
    OnUseRemote();
    pureVRML97 = swGetCheck(swGetDialogItem(_dlg, IDC_BROWSER_VRML97));
    remoteCommand = GetText(swGetDialogItem(_dlg, IDC_REMOTE_COMMAND));
    application = GetText(swGetDialogItem(_dlg, IDC_APPLICATION));
    topic = GetText(swGetDialogItem(_dlg, IDC_TOPIC));

    swBrowserSetSettings(TheApp->GetBrowser(), command, pureVRML97, useRemote,
    			 remoteCommand, application, topic);
}

void PreviewSettingsDialog::OnBrowse() 
{
    char	buf[1024] = "";

    if (swOpenFileDialog(_dlg, "Select",
		     "Executable Files (*.exe)\0*.exe\0All Files (*.*)\0*.*\0\0",
		     buf, 1024)) {
	swSetText(swGetDialogItem(_dlg, IDC_COMMAND), buf);
    }
}

void
PreviewSettingsDialog::OnUseRemote()
{
    int	    flag = swGetCheck(swGetDialogItem(_dlg, IDC_USE_REMOTE));

    swEnableWindow(swGetDialogItem(_dlg, IDC_REMOTE_COMMAND), flag);
    swEnableWindow(swGetDialogItem(_dlg, IDC_APPLICATION), flag);
    swEnableWindow(swGetDialogItem(_dlg, IDC_TOPIC), flag);
}
