/*
 * SFRotation.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _SFROTATION_H
#define _SFROTATION_H

#ifndef _FIELDVALUE_H
#include "FieldValue.h"
#endif
#ifndef _VEC3F_H
#include "Vec3f.h"
#endif
#ifndef _MATRIX_H
#include "Matrix.h"
#endif
#ifndef _QUATERNION_H
#include "Quaternion.h"
#endif

class SFRotation : public FieldValue {
public:
			SFRotation(float x, float y, float z, float w);
			SFRotation(const float *value);
			SFRotation(Vec3f euler, int mode);
			SFRotation(const Quaternion &q);
			SFRotation(const Matrix &mat);
                        SFRotation(void);  // silly default

    void		generateQuaternion();
    virtual int         getType() const { return SFROTATION; }
    virtual const char *getTypeName() const { return "SFRotation"; }
    virtual int	        write(int filedes, int indent) const;
    virtual bool	equals(const FieldValue *value) const;
    virtual FieldValue *copy() { return new SFRotation(*this); }

    const float	       *getValue() const { return _value; }
    Vec3f		getEulerAngles(int order);
    void		setEulerAngles(Vec3f angles, int order);
    const Quaternion   &getQuat() const;
    void		normalize();

    Vec3f		operator *(const Vec3f &v) const;

    MyString	        getEcmaScriptComment(MyString name, int flags) const;

    bool                isAnimateable() const { return true; }
    bool                hasAnimationSupport() { return true; }

private:
    Quaternion		_quaternion;
    float		_value[4];
    Vec3f		_euler;
    int			_eulerOrder;
    bool		_eulerDirty;
};

#endif // _SFROTATION_H
