/*
 * lexer.l
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

%{
#include <stdlib.h>
#include <string.h>
#include "stdafx.h"

#include "Element.h"
#include "EventIn.h"
#include "EventOut.h"
#include "ExposedField.h"
#include "Field.h"
#include "FieldValue.h"
#include "Node.h"
#include "Scene.h"

#include "SFBool.h"
#include "SFNode.h"
#include "MFNode.h"
#include "SFString.h"

#include "parser.h"
#include "y.tab.h"

#define YY_NEVER_INTERACTIVE 1

#ifdef HAVE_LIBZ
# define YY_INPUT(buf, result, max_size) \
	{ result = gzread( inputFile , buf, max_size ); }
#else
# define YY_INPUT(buf, result, max_size) \
	{ result = fread( buf, 1, max_size, inputFile ); }
#endif

#if defined(__sgi) && !defined(__GNUC__)
#pragma set woff 1110
#endif

int protoFlag=false;
int protoNested=0;
void startproto(void)
   {
   protoFlag=true;
   scene->addProtoDefinition();
   protoNested++;
   }
void toproto(char* string)
   {
   if (protoFlag)
      scene->addToProtoDefinition(string);
   }
void stopproto(void)
   {
   if (protoNested--==1)
      protoFlag=false;
   }

%}

IDFIRSTCHAR	[^ \r\n\t'\"#,\.\[\]\\\{\}0-9\+\-]
IDRESTCHARS	[^ \r\n\t'\"#,\.\[\]\\\{\}]

EXPONENT	([Ee]("-"|"+")?[0-9]+)

%%

("-"|"+")?([0-9]+"."[0-9]*|[0-9]*"."[0-9]+){EXPONENT}? {
                                                       toproto(yytext); 
                                                       yylval.sffloat = 
                                                          (float) atof(yytext); 
                                                       return FLOAT; 
                                                       }

("-"|"+")?[0-9]+{EXPONENT}	{
                                toproto(yytext); 
                                yylval.sffloat = (float) atof(yytext); 
                                return FLOAT; 
                                }

("-"|"+")?[0-9]+		{
                                toproto(yytext); 
                                yylval.int32 = atoi(yytext); 
                                return INT; 
                                }

("-"|"+")?0x[0-9a-fA-F]+	{ 
                                toproto(yytext); 
                                yylval.int32 = strtol(yytext, NULL, 16); 
                                return INT; 
                                }

Script		{ toproto(yytext); return SCRIPT; }

DEF		{ toproto(yytext); return DEF; }

EXTERNPROTO	{ startproto(); toproto(yytext); return EXTERNPROTO; }

FALSE		{ toproto(yytext); return FALSE_TOK; }

IS		{ toproto(yytext); return IS; }

NULL		{ toproto(yytext); return NULL_TOK; }

PROTO		{ startproto(); toproto(yytext); return PROTO; }

ROUTE		{ toproto(yytext); return ROUTE; }

TO		{ toproto(yytext); return TO; }

TRUE		{ toproto(yytext); return TRUE_TOK; }

USE		{ toproto(yytext); return USE; }

eventIn		{ toproto(yytext); return EVENT_IN; }

eventOut	{ toproto(yytext); return EVENT_OUT; }

exposedField	{ toproto(yytext); return EXPOSED_FIELD; }

field		{ toproto(yytext); return FIELD; }

{IDFIRSTCHAR}{IDRESTCHARS}*	{
                                toproto(yytext); 
		                yylval.id = scene->addSymbol(yytext); 
                                return ID;
		                }

\"([^\"]|\\\"|\\\\)*\"	{
                        toproto(yytext); 
		        for (const char *s = yytext; *s; s++) {
		        if (*s == '\n') lineno++;
		        }
		        yytext[strlen(yytext)-1] = '\0';
		        yylval.id = scene->addSymbol(yytext+1);
		        return STRING;
		        }

"#"[^\n]*	        {
                        toproto(yytext); 
                        /* eat up comments */
                        }

[ \t\r,]+	        {
                        toproto(yytext); 
                        /* eat up whitespace and commas */
                        }

\n		        { 
                        toproto(yytext); 
                        lineno++; 
                        }

.		        {
                        toproto(yytext);  
                        return yytext[0]; 
                        }

%%
