/*
 * main.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "stdafx.h"

#include "swt.h"

#include "DuneApp.h"
#include "MainWindow.h"
#include "xerrorhandler.h"

#ifdef WIN32
#  define errorprintf msgboxprintf
#else
#  define errorprintf fprintf   
#endif

extern bool parseCommandlineArgumentInputDevice(int & i,int argc, char** argv);

bool parseCommandlineArgument(int & i,int argc, char** argv)
{
    bool found=true;
    if (strcmp(argv[i],"-nostereo")==0)
       return found;
    else if (strcmp(argv[i],"-eyedist")==0) {
       float eyedist;
       if (i++>=argc) return found;
       if (sscanf(argv[i],"%f",&eyedist)==1)
          TheApp->setEyeDist(eyedist);
    } else if (strcmp(argv[i],"-screendist")==0) {
       float screendist;
       if (i++>=argc) return found;
       if (sscanf(argv[i],"%f",&screendist)==1)
          TheApp->setEyeScreenDist(screendist);
    } else if (strcmp(argv[i],"-fieldofview")==0) {
       float fov;
       if (i++>=argc) return found;
       if (sscanf(argv[i],"%f",&fov)==1)
          TheApp->setFixFieldOfView(fov);
#ifdef __APPLE__
    } else if (stringncmp(argv[i],"-psn_")==0) {
           // parse special MacOSX commandline parameters
#endif
    } else
       return parseCommandlineArgumentInputDevice(i, argc, argv);
    return found;    
}


#ifdef WIN32
void emergency_rescue(void)
{
    TheApp->emergency_rescue();
}

void startmainloop(void)
{
#ifndef HAVE_WANT_CORE
    __try {
#endif
       swMainLoop();
#ifndef HAVE_WANT_CORE
    } __except(EXCEPTION_EXECUTE_HANDLER) {
       emergency_rescue();
    }
#endif
}

// count words in a string with spaces

int get_argc_lpCmdLine(LPSTR lpCmdLine)
{
    int number_arguments=1;
    if (lpCmdLine[0]==0)
       return(number_arguments);
    for (int i=1;i<strlen(lpCmdLine);i++)
       if ((lpCmdLine[i]==' ') && (lpCmdLine[i-1]!=' '))
          number_arguments++;
    if (lpCmdLine[strlen(lpCmdLine)-1]!=' ')
       number_arguments++;
    return number_arguments;
}

// split string with spaces into unixlike argv structure

void get_argv_lpCmdLine(char** argv,int argc,LPSTR lpCmdLine)
{
    char* startptr=lpCmdLine;
    static char* dunename="dune";
    argv[0]=dunename;
    int number_argument=1;
    for (int i=1;i<strlen(lpCmdLine);i++) {
       if ((lpCmdLine[i]==' ') && (lpCmdLine[i-1]!=' ')) {
          argv[number_argument]=(char*) malloc(lpCmdLine+i-startptr+1);
          mystrncpy_danger(argv[number_argument],startptr,lpCmdLine+i-startptr);
          number_argument++;
       }
       if ((lpCmdLine[i]!=' ') && (lpCmdLine[i-1]==' '))
         startptr=lpCmdLine+i;
    }
    if (lpCmdLine[strlen(lpCmdLine)-1]!=' ') {
       argv[number_argument]=(char*) malloc(lpCmdLine+i-startptr+1);
       mystrncpy_danger(argv[number_argument],startptr,lpCmdLine+i-startptr);
    }
}

// skip arguments with a '-' sign in front and return rest

char* skiparguments(LPSTR lpCmdLine)
{
    if (lpCmdLine[0]==0)
       return lpCmdLine;

    if (lpCmdLine[0]!='-')
       if (lpCmdLine[0]!=' ')
          return lpCmdLine;

    for (int i=1;i<strlen(lpCmdLine);i++) {
       if (lpCmdLine[i]!='-')
          if ((lpCmdLine[i]!=' ') && (lpCmdLine[i-1]==' '))
             return lpCmdLine+i;
    // all are arguments 
    return NULL;
    }
}

// define if you have the CommandLineToArgvW(function) (WindowsNT 3.5 and later)
// #define HAVE_COMMANDLINE_TO_ARGV_W 1

int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE prevInstance,
		    LPSTR lpCmdLine, int nCmdShow)
{
    int argc;
    char** argv;
    swInitialize(hInstance);
    TheApp = new DuneApp();
    TheApp->setCanStereo(false);
#ifdef HAVE_COMMANDLINE_TO_ARGV_W
    argv=CommandLineToArgvW(lpCmdLine,&argc);
#else
    argc=get_argc_lpCmdLine(lpCmdLine);
    argv=(char**) malloc((argc+1)*sizeof(char**));
    get_argv_lpCmdLine(argv,argc,lpCmdLine);
#endif
    int i=1;
    bool fileflag=false;
    bool fileerrorflag=false;
    while (i<argc) {
       if (!parseCommandlineArgument(i,argc,argv)) {
          if (!TheApp->OpenFile(argv[i])) {
             // some of this buggy M$Windows filenames with blanks ?
             fileerrorflag=true; 
          } else {
             fileflag=true;
          }
       }
       i++;
    }
    TheApp->accoutMaxNumberAxesInputDevices();
    if ((fileerrorflag==false) && (i>argc)) {
       errorprintf(stderr,"usage:  %s [options] [file.wrl]\n",argv[0]);
       return 1;
    }
    if (fileerrorflag==true) { 
       if (skiparguments(lpCmdLine)==NULL) {
          // all arguments, but one must be wrong (cause of fileerrorflag)
          errorprintf(stderr,"some of the options is invalid\n");
          return 1;
       }
       if (TheApp->OpenFile(skiparguments(lpCmdLine)))
          fileflag=true; 
       else {
          errorprintf(stderr,"can not open %s\n",skiparguments(lpCmdLine));
          return 1;
       }
    }
    if (!fileflag)
       TheApp->OnFileNewWindow();
    startmainloop();
    delete TheApp;
    return 0;
}

#else
int main(int argc, char *argv[])
{
    TheApp = new DuneApp();
    int i;
    bool *files=new bool[argc+1];
    for (i=1;i<argc;i++)
       files[i]=false;
    int stereoflag=1;
    for (i=1;i<argc;i++)
       if (strcmp(argv[i],"-nostereo")==0)
          stereoflag=0;
    bool wantStereo=TheApp->GetBoolPreference("WantStereo", true);
    if (!wantStereo)
        stereoflag=0;
    stereoflag=swInitialize(&argc, argv, stereoflag);
    if (stereoflag) {
       TheApp->setCanStereo(true);
       TheApp->setUseStereo(true);
    } else {
       TheApp->setCanStereo(false);
    }
    i=1;
    bool fileflag=false;
    while (i<argc) {
       files[i]=false;
       if (!parseCommandlineArgument(i,argc,argv)) {
          files[i]=true;
          fileflag=true;
       }
       i++;
    }
    TheApp->accoutMaxNumberAxesInputDevices();
    if (i>argc) {
       errorprintf(stderr, 
            "usage:  %s [options] [file.wrl]\n",
             argv[0]);
       return 1;
       }
    for (i=1;i<argc;i++)
       if (files[i]==true)
          if (!TheApp->OpenFile(argv[i])) {
             perror(argv[i]);
             return(1);
          }
    if (!fileflag)
       TheApp->OnFileNewWindow();
#ifdef HAVE_FPU_ENABLE_INTERRUPTS
    fpu_enable_interrupts();
#endif
    swMainLoop();
    delete TheApp;
    return 0;
}
#endif
