/*
 * MFInt32.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _MFINT32_H
#define _MFINT32_H

#ifndef _ARRAY_H
#include "Array.h"
#endif
#ifndef _FIELDVALUE_H
#include "FieldValue.h"
#endif

class MFInt32 : public MFieldValue {
public:
			MFInt32();
			MFInt32(int *values, int len);
			MFInt32(const MFInt32 &value);
			MFInt32(int value);
    virtual	       ~MFInt32();			

    virtual int         getType() const { return MFINT32; }
    virtual const char *getTypeName() const { return "MFInt32"; }
    virtual int         write(int filedes, int indent) const;
//    virtual int		writeCC(int filedes, char* variableName) const;
    virtual bool	equals(const FieldValue *value) const;
    virtual int		getSFSize() const { return _value.size(); }
    virtual FieldValue *getSFValue(int index) const;
    virtual void	setSFValue(int index, FieldValue *value);
    virtual void	setSFValue(int index, int value);
    virtual FieldValue *copy();

    int			getValue(int index) const { return _value[index]; }
    const int          *getValues() const { return _value.getData(); }
    int			getSize() const { return _value.size(); }

    virtual void        insertSFValue(int index, FieldValue *value);
    virtual void        insertSFValue(int index, int value);
    virtual void        removeSFValue(int index) { _value.remove(index); }

    MyString	        getEcmaScriptComment(MyString name, int flags) const;

    bool                isAnimateable() const { return false; }

private:
    Array<int>          _value;
};

#endif // _MFINT32_H
