
#ifndef _BORDER_H_
#define _BORDER_H_

#include "General.h"
extern "C" {
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
}

class Client;
class WindowManager;

#define GTK_XWINDOW(w) (GTK_WIDGET_NO_WINDOW(w) ? GDK_WINDOW_XWINDOW(gtk_widget_get_parent_window(GTK_WIDGET(w))) : GDK_WINDOW_XWINDOW(GTK_WIDGET(w)->window))

class Border {
public:
    Border(Client *const, Window child);
    ~Border();
    void map();
    void unmap();
    void lower();
    void mapRaised();
    void decorate(Boolean active, int w, int h);
    void reparent();
    void configure(int x, int y, int w, int h, unsigned long mask, int detail, Boolean active = False, Boolean onlyActivate = False);
    void moveTo(int x, int y);
    WindowManager *windowManager();
    Boolean isTransient();
    Boolean isFixedSize();
    Window parent() {
        return m_parent;
    }
    Boolean hasWindow(Window w) {
        return (w != root() && (w == m_parent || w == m_tab || w == m_hideButton || w == m_closeButton || w == (m_tabGtk ? GTK_XWINDOW(m_tabGtk) : 0) || w == (m_labelGtk ? GTK_XWINDOW(m_labelGtk) : 0) || w == (m_hideButtonGtk ? GTK_XWINDOW(m_hideButtonGtk) : 0) || w == (m_closeButtonGtk ? GTK_XWINDOW(m_closeButtonGtk) : 0)));
    }
    Display *display();
    Window root();
    void expose(XExposeEvent *);
    void eventButton(XButtonEvent *);
    int yIndent() {
        return title_size + frame_size * 2;
    }
    int xIndent() {
        return frame_size;
    }
    void maximize();

private:
    Client *m_client;
    Window m_parent;
    Window m_tab;
    Window m_child;
    Window m_hideButton;
    Window m_closeButton;
    GtkWidget *m_tabGtk;
    GtkWidget *m_hideButtonGtk;
    GtkWidget *m_closeButtonGtk;
    GtkWidget *m_labelGtk;
    GdkWindow *m_gdkwindow;
    void fatal(char *);
    char *m_label;
    void drawLabel();
    void shapeParent(int, int);
    void shapeTab(int, int);
private:
    static GC m_drawGC;
    static unsigned long m_frameBackgroundPixel;
    static unsigned long m_buttonBackgroundPixel;
    static unsigned long m_borderPixel;
};

#endif
