
#ifndef _CLIENT_H_
#define _CLIENT_H_

#include "General.h"
#include "Manager.h"
#include "Border.h"

typedef enum {
    H_LEFT = 2,
    H_RIGHT = 1,
    H_NONE = 0
} HDir;

typedef enum {
    V_UP = 2,
    V_DOWN = 1,
    V_NONE = 0
} VDir;

class Client {
    friend class Border;
    friend class WindowManager;
public:
    Client(WindowManager *const, Window);
    void release();
    void activate();
    void deactivate();
    void gravitate(Boolean invert);
    void installColormap();
    void unreparent();
    void withdraw(Boolean = True);
    void hide();
    void unhide(Boolean map);
    void rename();
    void kill();
    void mapRaised();
    void lower();
    void move(XButtonEvent *);
    void resize(XButtonEvent *, HDir, VDir);
    void moveOrResize(XButtonEvent *);
    void ensureVisible();
    void manage(Boolean mapped);
    Boolean hasWindow(Window w) {
        return ((m_window == w) || m_border->hasWindow(w));
    }
    Client *revertTo() {
        return m_revert;
    }
    void setRevertTo(Client *c) {
        m_revert = c;
    }
    Boolean isHidden()     {
        return (m_state == IconicState);
    }
    Boolean isWithdrawn()  {
        return (m_state == WithdrawnState);
    }
    Boolean isNormal()     {
        return (m_state == NormalState);
    }
    Boolean isTransient()  {
        return (m_transient != None);
    }
    Window  transientFor() {
        return m_transient;
    }
    Boolean isFixedSize()  {
        return m_fixedSize;
    }
    const char *label()    {
        return m_label;
    }
    const char *name()     {
        return m_name;
    }
    const char *iconName() {
        return m_iconName;
    }
    void sendMessage(Atom, long);
    void sendConfigureNotify();
    void activateAndWarp();
    void focusIfAppropriate(Boolean);
    void selectOnMotion(Window, Boolean);
    void fatal(char *m)    {
        m_windowManager->fatal(m);
    }
    Display *display()     {
        return m_windowManager->display();
    }
    Window handle()        {
        return m_window;
    }
    Window parent()        {
        return m_border->parent();
    }
    Window root()          {
        return m_windowManager->root();
    }
    Client *activeClient() {
        return m_windowManager->activeClient();
    }
    Boolean isActive()     {
        return (activeClient() == this);
    }
    WindowManager *windowManager() {
        return m_windowManager;
    }
    void eventButton(XButtonEvent *);
    void eventMapRequest(XMapRequestEvent *);
    void eventConfigureRequest(XConfigureRequestEvent *);
    void eventUnmap(XUnmapEvent *);
    void eventColormap(XColormapEvent *);
    void eventProperty(XPropertyEvent *);
    void eventEnter(XCrossingEvent *);
    void eventFocusIn(XFocusInEvent *);
    void eventFocusOut(XFocusOutEvent *);
    void eventExposure(XExposeEvent *);
    bool getWinLayerHint(long *);
    long Layer() {
        return layer;
    }
    bool managed() {
        return m_managed;
    }
    void setSize(int, int, int, int);
protected:
    ~Client();
private:
    Window m_window;
    Window m_transient;
    Border *m_border;
    Client *m_revert;
    int m_x;
    int m_y;
    int m_w;
    int m_h;
    int m_bw;
    long layer;
    XSizeHints m_sizeHints;
    Boolean m_fixedSize;
    int m_minWidth;
    int m_minHeight;
    void fixResizeDimensions(int &, int &, int &, int &);
    int m_state;
    int m_protocol;
    Boolean m_managed;
    Boolean m_reparenting;
    Boolean m_stubborn;
    Boolean m_hasTitle;
    Boolean m_hasBorder;
    Time m_lastPopTime;
    MwmHints *m_mwmHints;
    char *m_name;
    char *m_iconName;
    char *m_label;
    static const char *const m_defaultLabel;
    Colormap m_colormap;
    int m_colormapWinCount;
    Window *m_colormapWindows;
    Colormap *m_windowColormaps;
    WindowManager *const m_windowManager;
    char *getProperty(Atom);
    int getAtomProperty(Atom, Atom);
    int getIntegerProperty(Atom);
    Boolean getState(int *);
    void setState(int);
    Boolean setLabel(void);
    void getColormaps(void);
    void getProtocols(void);
    void getTransient(void);
    void getMwmHints(void);
    void decorate(Boolean active);
};

#define Pdelete    1
#define PtakeFocus 2

#endif
