
#ifndef _MANAGER_H_
#define _MANAGER_H_

#include "General.h"
#include "listmacro2.h"

void initAtoms();

class Client;
declarePList(ClientList, Client);

class WindowManager {
    friend class Border;
public:
    WindowManager();
    ~WindowManager();
    void fatal(const char *);
    Client *windowToClient(Window, Boolean create = False);
    Client *activeClient() {
        return m_activeClient;
    }
    Boolean raiseTransients(Client *);
    Time timestamp(Boolean reset);
    void clearFocus();
    void setActiveClient(Client *const c) {
        m_activeClient = c;
    }
    void addToHiddenList(Client *);
    void removeFromHiddenList(Client *);
    void skipInRevert(Client *, Client *);
    Display *display() {
        return m_display;
    }
    Window root() {
        return m_root;
    }
    Window rootProxy() {
        return root_proxy;
    }
    enum RootCursor {
        NormalCursor, DeleteCursor, DownCursor, RightCursor, DownrightCursor
    };
    void installCursor(RootCursor);
    void installCursorOnWindow(RootCursor, Window);
    void installColormap(Colormap);
    unsigned long allocateColour(char *, char *);
    void considerFocusChange(Client *, Window, Time timestamp);
    void stopConsideringFocus();
    int attemptGrab(Window, Window, int, int);
    void releaseGrab(XButtonEvent *);
    void eventExposure(XExposeEvent *);
    void updateClientList();
private:
    int loop();
    void release();
    Display *m_display;
    int m_screenNumber;
    Window m_root;
    Window root_proxy;
    Colormap m_defaultColormap;
    int m_minimumColormaps;
    Cursor m_cursor;
    Cursor m_xCursor;
    Cursor m_vCursor;
    Cursor m_hCursor;
    Cursor m_vhCursor;
    ClientList m_clients;
    ClientList m_hiddenClients;
    Client *m_activeClient;
    int m_shapeEvent;
    int m_currentTime;
    static Boolean m_looping;
    int m_returnCode;
    static Boolean m_initialising;
    static int errorHandler(Display *, XErrorEvent *);
    static void sigHandler();
    static int m_signalled;
    void initialiseScreen();
    void scanInitialWindows();
    void spawn();
    void circulate(Boolean activeFirst);
    Boolean m_focusChanging;
    Client *m_focusCandidate;
    Window  m_focusCandidateWindow;
    Time    m_focusTimestamp;
    Boolean m_focusPointerMoved;
    Boolean m_focusPointerNowStill;
    void checkDelaysForFocus();
    void nextEvent(XEvent *);
    void eventButton(XButtonEvent *);
    void eventMapRequest(XMapRequestEvent *);
    void eventConfigureRequest(XConfigureRequestEvent *);
    void eventUnmap(XUnmapEvent *);
    void eventCreate(XCreateWindowEvent *);
    void eventDestroy(XDestroyWindowEvent *);
    void eventClient(XClientMessageEvent *);
    void eventColormap(XColormapEvent *);
    void eventProperty(XPropertyEvent *);
    void eventEnter(XCrossingEvent *);
    void eventReparent(XReparentEvent *);
    void eventFocusIn(XFocusInEvent *);
    void eventFocusOut(XFocusOutEvent *);
};

#endif
