#include <X11/Xlib.h>
#include <gnome.h>
#include <gdk/gdkx.h>
#include "config.h"

gboolean exitflag = FALSE;
gboolean click_to_focus;
gboolean raise_on_focus;
gboolean auto_raise;
guint auto_raise_delay;
guint CONFIG_POINTER_STOPPED_DELAY = 80;
gchar *border_fg;
gchar *frame_bg;
gchar *button_bg;
guint title_size;
guint frame_size;
GtkWidget *titlespin;
GtkWidget *framespin;
GtkWidget *borderfgsel;
GtkWidget *buttonbgsel;
GtkWidget *framebgsel;
GtkWidget *ctfbutton;
GtkWidget *rofbutton;
GtkWidget *arbutton;
GtkWidget *ardspin;

static Window find_gnome_wm_window();

void wmgconf_changed(GtkWidget *w, GnomePropertyBox *dialog) {
    gnome_property_box_changed(dialog);
}

void wmgconf_color_changed(GtkWidget *w, guint a, guint b, guint c, guint d, GnomePropertyBox *dialog) {
    wmgconf_changed(w, dialog);
}

void wmgconf_apply() {
    static char *comm[] = {"wmG"};
    guint8 r, g, b;
    title_size = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(titlespin));
    frame_size = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(framespin));
    click_to_focus = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ctfbutton));
    raise_on_focus = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(rofbutton));
    auto_raise = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(arbutton));
    auto_raise_delay = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(ardspin));
    gnome_color_picker_get_i8(GNOME_COLOR_PICKER(borderfgsel), &r, &g, &b, 0);
    g_snprintf(border_fg, 8, "#%02x%02x%02x", r, g, b);
    gnome_color_picker_get_i8(GNOME_COLOR_PICKER(buttonbgsel), &r, &g, &b, 0);
    g_snprintf(button_bg, 8, "#%02x%02x%02x", r, g, b);
    gnome_color_picker_get_i8(GNOME_COLOR_PICKER(framebgsel), &r, &g, &b, 0);
    g_snprintf(frame_bg, 8, "#%02x%02x%02x", r, g, b);
    XKillClient(GDK_DISPLAY(), find_gnome_wm_window());
    gnome_execute_async(0, 1, comm);
}

int main(int argc, char **argv) {
    GdkColor colortmp;
    guint8 r, g, b;
    GtkWidget *dialog;
    GtkWidget *options;
    GtkWidget *optionpacker;
    GtkWidget *sizepacker;
    GtkWidget *titlepacker;
    GtkWidget *titlelabel;
    GtkWidget *framepacker;
    GtkWidget *framelabel;
    GtkWidget *focuspacker;
    GtkWidget *ardpacker;
    GtkWidget *ardlabel;
    GtkWidget *colors;
    GtkWidget *colorpacker;
    GtkWidget *borderfgpacker;
    GtkWidget *borderfglabel;
    GtkWidget *buttonbgpacker;
    GtkWidget *buttonbglabel;
    GtkWidget *framebgpacker;
    GtkWidget *framebglabel;
    gnome_init(PACKAGE, VERSION, argc, argv);
    click_to_focus = gnome_config_get_bool("/wmG/properties/CLICK_TO_FOCUS=True");
    raise_on_focus = gnome_config_get_bool("/wmG/properties/RAISE_ON_FOCUS=True");
    auto_raise = gnome_config_get_bool("/wmG/properties/AUTO_RAISE=False");
    auto_raise_delay = gnome_config_get_int("/wmG/properties/AUTO_RAISE_DELAY=400");
    title_size = gnome_config_get_int("/wmG/properties/TITLEBAR_SIZE=12");
    frame_size = gnome_config_get_int("/wmG/properties/FRAME_SIZE=2");
    border_fg = gnome_config_get_string("/wmG/properties/BORDER_COLOR=black");
    frame_bg = gnome_config_get_string("/wmG/properties/FRAME_BACKGROUND=gray95");
    button_bg = gnome_config_get_string("/wmG/properties/BUTTON_BACKGROUND=gray95");
    dialog = gnome_property_box_new();
    options = gtk_frame_new(NULL);
    optionpacker = gtk_packer_new();
    sizepacker = gtk_packer_new();
    titlepacker = gtk_packer_new();
    titlelabel = gtk_label_new("Titlebar: ");
    titlespin = gtk_spin_button_new(GTK_ADJUSTMENT(gtk_adjustment_new(title_size, 12, 45, 1, 1, 1)), 1, 0);
    framepacker = gtk_packer_new();
    framelabel = gtk_label_new("Frame: ");
    framespin = gtk_spin_button_new(GTK_ADJUSTMENT(gtk_adjustment_new(frame_size, 1, 15, 1, 1, 1)), 1, 0);
    focuspacker = gtk_packer_new();
    ctfbutton = gtk_toggle_button_new_with_label("Click to focus");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ctfbutton), click_to_focus);
    rofbutton = gtk_toggle_button_new_with_label("Raise on focus");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(rofbutton), raise_on_focus);
    arbutton = gtk_toggle_button_new_with_label("Auto raise");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(arbutton), auto_raise);
    ardpacker = gtk_packer_new();
    ardlabel = gtk_label_new("Auto raise delay: ");
    ardspin = gtk_spin_button_new(GTK_ADJUSTMENT(gtk_adjustment_new(auto_raise_delay, 1, 30000, 1, 1, 1)), 1, 0);
    colors = gtk_frame_new(NULL);
    colorpacker = gtk_packer_new();
    borderfgpacker = gtk_packer_new();
    borderfglabel = gtk_label_new("Frame Border: ");
    borderfgsel = gnome_color_picker_new();
    gdk_color_parse(border_fg, &colortmp);
    r = colortmp.red >> 8;
    g = colortmp.green >> 8;
    b = colortmp.blue >> 8;
    gnome_color_picker_set_i8(GNOME_COLOR_PICKER(borderfgsel), r, g, b, 0);
    buttonbgpacker = gtk_packer_new();
    buttonbglabel = gtk_label_new("Button Color: ");
    buttonbgsel = gnome_color_picker_new();
    gdk_color_parse(button_bg, &colortmp);
    r = colortmp.red >> 8;
    g = colortmp.green >> 8;
    b = colortmp.blue >> 8;
    gnome_color_picker_set_i8(GNOME_COLOR_PICKER(buttonbgsel), r, g, b, 0);
    framebgpacker = gtk_packer_new();
    framebglabel = gtk_label_new("Frame Color: ");
    framebgsel = gnome_color_picker_new();
    gdk_color_parse(frame_bg, &colortmp);
    r = colortmp.red >> 8;
    g = colortmp.green >> 8;
    b = colortmp.blue >> 8;
    gnome_color_picker_set_i8(GNOME_COLOR_PICKER(framebgsel), r, g, b, 0);
    gtk_window_set_policy(GTK_WINDOW(dialog), FALSE, FALSE, FALSE);
    gnome_property_box_append_page(GNOME_PROPERTY_BOX(dialog), options, gtk_label_new("Options"));
    gtk_container_add(GTK_CONTAINER(options), optionpacker);
    gtk_packer_add(GTK_PACKER(optionpacker), sizepacker, GTK_SIDE_LEFT, GTK_ANCHOR_CENTER, (GtkPackerOptions)0, 0, 0, 0, 0, 0);
    gtk_packer_add(GTK_PACKER(sizepacker), titlepacker, GTK_SIDE_TOP, GTK_ANCHOR_CENTER, (GtkPackerOptions)0, 0, 0, 0, 0, 0);
    gtk_packer_add(GTK_PACKER(titlepacker), titlelabel, GTK_SIDE_LEFT, GTK_ANCHOR_CENTER, (GtkPackerOptions)0, 0, 0, 0, 0, 0);
    gtk_packer_add(GTK_PACKER(titlepacker), titlespin, GTK_SIDE_LEFT, GTK_ANCHOR_CENTER, (GtkPackerOptions)0, 0, 0, 0, 0, 0);
    gtk_packer_add(GTK_PACKER(sizepacker), framepacker, GTK_SIDE_TOP, GTK_ANCHOR_CENTER, (GtkPackerOptions)0, 0, 0, 0, 0, 0);
    gtk_packer_add(GTK_PACKER(framepacker), framelabel, GTK_SIDE_LEFT, GTK_ANCHOR_CENTER, (GtkPackerOptions)0, 0, 0, 0, 0, 0);
    gtk_packer_add(GTK_PACKER(framepacker), framespin, GTK_SIDE_LEFT, GTK_ANCHOR_CENTER, (GtkPackerOptions)0, 0, 0, 0, 0, 0);
    gtk_packer_add(GTK_PACKER(optionpacker), focuspacker, GTK_SIDE_RIGHT, GTK_ANCHOR_CENTER, (GtkPackerOptions)0, 0, 0, 0, 0, 0);
    gtk_packer_add(GTK_PACKER(focuspacker), ctfbutton, GTK_SIDE_TOP, GTK_ANCHOR_CENTER, (GtkPackerOptions)0, 0, 0, 0, 0, 0);
    gtk_packer_add(GTK_PACKER(focuspacker), rofbutton, GTK_SIDE_TOP, GTK_ANCHOR_CENTER, (GtkPackerOptions)0, 0, 0, 0, 0, 0);
    gtk_packer_add(GTK_PACKER(focuspacker), arbutton, GTK_SIDE_TOP, GTK_ANCHOR_CENTER, (GtkPackerOptions)0, 0, 0, 0, 0, 0);
    gtk_packer_add(GTK_PACKER(focuspacker), ardpacker, GTK_SIDE_TOP, GTK_ANCHOR_CENTER, (GtkPackerOptions)0, 0, 0, 0, 0, 0);
    gtk_packer_add(GTK_PACKER(ardpacker), ardlabel, GTK_SIDE_LEFT, GTK_ANCHOR_CENTER, (GtkPackerOptions)0, 0, 0, 0, 0, 0);
    gtk_packer_add(GTK_PACKER(ardpacker), ardspin, GTK_SIDE_LEFT, GTK_ANCHOR_CENTER, (GtkPackerOptions)0, 0, 0, 0, 0, 0);
    gnome_property_box_append_page(GNOME_PROPERTY_BOX(dialog), colors, gtk_label_new("Colors"));
    gtk_container_add(GTK_CONTAINER(colors), colorpacker);
    gtk_packer_add(GTK_PACKER(colorpacker), borderfgpacker, GTK_SIDE_TOP, GTK_ANCHOR_CENTER, (GtkPackerOptions)0, 0, 0, 0, 0, 0);
    gtk_packer_add(GTK_PACKER(borderfgpacker), borderfglabel, GTK_SIDE_LEFT, GTK_ANCHOR_CENTER, (GtkPackerOptions)0, 0, 0, 0, 0, 0);
    gtk_packer_add(GTK_PACKER(borderfgpacker), borderfgsel, GTK_SIDE_LEFT, GTK_ANCHOR_CENTER, (GtkPackerOptions)0, 0, 0, 0, 0, 0);
    gtk_packer_add(GTK_PACKER(colorpacker), buttonbgpacker, GTK_SIDE_TOP, GTK_ANCHOR_CENTER, (GtkPackerOptions)0, 0, 0, 0, 0, 0);
    gtk_packer_add(GTK_PACKER(buttonbgpacker), buttonbglabel, GTK_SIDE_LEFT, GTK_ANCHOR_CENTER, (GtkPackerOptions)0, 0, 0, 0, 0, 0);
    gtk_packer_add(GTK_PACKER(buttonbgpacker), buttonbgsel, GTK_SIDE_LEFT, GTK_ANCHOR_CENTER, (GtkPackerOptions)0, 0, 0, 0, 0, 0);
    gtk_packer_add(GTK_PACKER(colorpacker), framebgpacker, GTK_SIDE_TOP, GTK_ANCHOR_CENTER, (GtkPackerOptions)0, 0, 0, 0, 0, 0);
    gtk_packer_add(GTK_PACKER(framebgpacker), framebglabel, GTK_SIDE_LEFT, GTK_ANCHOR_CENTER, (GtkPackerOptions)0, 0, 0, 0, 0, 0);
    gtk_packer_add(GTK_PACKER(framebgpacker), framebgsel, GTK_SIDE_LEFT, GTK_ANCHOR_CENTER, (GtkPackerOptions)0, 0, 0, 0, 0, 0);
    gtk_signal_connect(GTK_OBJECT(titlespin), "changed", GTK_SIGNAL_FUNC(&wmgconf_changed), dialog);
    gtk_signal_connect(GTK_OBJECT(framespin), "changed", GTK_SIGNAL_FUNC(&wmgconf_changed), dialog);
    gtk_signal_connect(GTK_OBJECT(ctfbutton), "toggled", GTK_SIGNAL_FUNC(&wmgconf_changed), dialog);
    gtk_signal_connect(GTK_OBJECT(rofbutton), "toggled", GTK_SIGNAL_FUNC(&wmgconf_changed), dialog);
    gtk_signal_connect(GTK_OBJECT(arbutton), "toggled", GTK_SIGNAL_FUNC(&wmgconf_changed), dialog);
    gtk_signal_connect(GTK_OBJECT(ardspin), "changed", GTK_SIGNAL_FUNC(&wmgconf_changed), dialog);
    gtk_signal_connect(GTK_OBJECT(borderfgsel), "color_set", GTK_SIGNAL_FUNC(&wmgconf_color_changed), dialog);
    gtk_signal_connect(GTK_OBJECT(buttonbgsel), "color_set", GTK_SIGNAL_FUNC(&wmgconf_color_changed), dialog);
    gtk_signal_connect(GTK_OBJECT(framebgsel), "color_set", GTK_SIGNAL_FUNC(&wmgconf_color_changed), dialog);
    gtk_signal_connect(GTK_OBJECT(dialog), "apply", GTK_SIGNAL_FUNC(&wmgconf_apply), NULL);
    gtk_signal_connect(GTK_OBJECT(GNOME_PROPERTY_BOX(dialog)->ok_button), "clicked", GTK_SIGNAL_FUNC(&gtk_main_quit), NULL);
    gtk_signal_connect(GTK_OBJECT(GNOME_PROPERTY_BOX(dialog)->cancel_button), "clicked", GTK_SIGNAL_FUNC(&gtk_main_quit), NULL);
    gtk_widget_show_all(dialog);
    gtk_main();
    gnome_config_set_bool("/wmG/properties/CLICK_TO_FOCUS", click_to_focus);
    gnome_config_set_bool("/wmG/properties/RAISE_ON_FOCUS", raise_on_focus);
    gnome_config_set_bool("/wmG/properties/AUTO_RAISE", auto_raise);
    gnome_config_set_int("/wmG/properties/AUTO_RAISE_DELAY", auto_raise_delay);
    gnome_config_set_int("/wmG/properties/TITLEBAR_SIZE", title_size);
    gnome_config_set_int("/wmG/properties/FRAME_SIZE", frame_size);
    gnome_config_set_string("/wmG/properties/BORDER_COLOR", border_fg);
    gnome_config_set_string("/wmG/properties/FRAME_BACKGROUND", frame_bg);
    gnome_config_set_string("/wmG/properties/BUTTON_BACKGROUND", button_bg);
    gnome_config_sync();
    return 0;
}

static Window find_gnome_wm_window() {
    Atom r_type;
    int r_format;
    unsigned long count;
    unsigned long bytes_remain;
    unsigned char *prop, *prop2;
    gint prev_error;
    GdkAtom cardinal_atom = gdk_atom_intern ("CARDINAL", FALSE);
    prev_error = gdk_error_warnings;
    gdk_error_warnings = 0;  
    if(XGetWindowProperty(GDK_DISPLAY(), GDK_ROOT_WINDOW(), gdk_atom_intern ("_WIN_SUPPORTING_WM_CHECK", FALSE), 0, 1, False, cardinal_atom, &r_type, &r_format, &count, &bytes_remain, &prop) == Success && prop) {
        if(r_type == cardinal_atom && r_format == 32 && count == 1) {
	    Window n = *(long *)prop;
	    if(XGetWindowProperty(GDK_DISPLAY(), n, gdk_atom_intern ("_WIN_SUPPORTING_WM_CHECK", FALSE), 0, 1, False, cardinal_atom, &r_type, &r_format, &count, &bytes_remain, &prop2) == Success && prop) {
	        if(r_type == cardinal_atom && r_format == 32 && count == 1) {
		    XFree(prop);
		    XFree(prop2);
		    gdk_error_warnings = prev_error;
		    return n;
		}
	        XFree(prop2);
	    }       
        }
        XFree(prop);
    }       
    gdk_error_warnings = prev_error;
    return None;
}
