#ifndef WMSCOREBOARD_H
#define WMSCOREBOARD_H

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <X11/X.h>
#include <X11/xpm.h>
#include "xutils.h"

/* Constants */

#define WMSCOREBOARD_VERSION "0.30"
#define WMSCOREBOARD_DATE "April 21, 2000"

#define MAX_COLS 11
#define CHAR_WIDTH 5
#define CHAR_HEIGHT 6
#define HORIZONTAL_MARGIN 4
#define VERTICAL_MARGIN 4
#define HORIZONTAL_SPACING 0
#define VERTICAL_SPACING 1
#define OK 0
#define ERROR 1
#define IDLE 2
#define DOWNLOADING 3
#define OFFLINE 4
#define ONLINE 5


/* Functions */

int   ParseCommandLine( int, char** );
int   CheckDir( void );
void  ProcessXEvents( void );
int   DownloadScore( void );
int   ReadScore( void );
void  ClearWindow( void );
void  PaintData( void );
void  PaintDownloadLED( int );
void  PaintOnlineLED( int );
void  PasteLED( int, int, int );
void  PasteChar( char, int, int, int );
void  PrintUsage( void );
void  ButtonPressEvent( XButtonEvent* );
void  KeyPressEvent( XKeyEvent* );
void  AlarmHandler( int );

#endif

