/* -*- C++ -*- */
/* $Id: wmpal.c,v 1.6 2001/04/20 00:38:21 asleep Exp $ */
/* src/wmpal.c */

/*  wmpal - a useless DockApp
 *  Copyright (C) 2000 Hadess <hadess@writeme.com>
 *  Copyright (C) 2001 A.Sleep <a.sleep@asleep.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <dockapp.h>
#include <unistd.h>
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <time.h>

#include "version.h"
#include "config.h"
#include "pals/pals.h"
#include "wmpal-master.xpm"

/*---------------------------------------------------------------------------*/
/*                             Prototypes                                    */
/*---------------------------------------------------------------------------*/

void ActionLaunch(int x, int y, DARect rect, void *data);

void ActionPrev(int x, int y, DARect rect, void *data);
void ActionNext(int x, int y, DARect rect, void *data);
void ActionLaunch(int x, int y, DARect rect, void *data);
void buttonPress(int button, int state, int x, int y);
void buttonRelease(int button, int state, int x, int y);
void *DisplayThread(void *p);
void *CheckThread(void *p);
void DrawName (char *name);
void DrawAnim(int anim_pos);
void sleep_1_to_n_seconds(int n);


/*----------------------------------------------------------------------------*/
/*                             Variables                                      */
/*----------------------------------------------------------------------------*/

char *launch_cmd="fortune | xsay -b Thanks -t wmpal ";

time_t t;
int n=5;
int anim_pos=0;
char *displayName = "";
GC gc;
Pixmap pixmap, mask;		/* Pixmap that is displayed */
Pixmap pixanim1, maskanim1;
Pixmap pixanim2, maskanim2;
Pixmap pixanim3, maskanim3;

static DAActionRect theRect[] = {
  {{1, 1, 48, 48}, ActionLaunch}
};

static DAProgramOption options[] = {
  {"-d", "--display", "Display to use", DOString, False, {&displayName} },
  {"-c", "--command", "Command to launch on click", DOString, False, {&launch_cmd} }
};

/*----------------------------------------------------------------------------*/
/*                              Functions                                     */
/*----------------------------------------------------------------------------*/

void ActionLaunch(int x, int y, DARect rect, void *data)
{
  char *command;
  int status;
  
  command=malloc(strlen(launch_cmd)+5);
  sprintf(command, "%s &", launch_cmd);
  status = system(command);
  if (status)
    fprintf(stderr, "Action can't be launched...");
  free(command);
}

void buttonPress(int button, int state, int x, int y)
{
  if (button == 1)
    {
      DAProcessActionRects(x, y, theRect, 3, NULL);
    }
}

/*----------------------------------------------------------------------------*/
/*                                   Main                                     */
/*----------------------------------------------------------------------------*/

int main(int argc, char **argv)
{
  unsigned height, width;
  DACallbacks callbacks={NULL, buttonPress, NULL, NULL,
			 NULL, NULL, NULL};
  
  DAParseArguments(argc, argv, options,
		   sizeof(options)/sizeof(DAProgramOption),
		   "Useless DockApp by Hadess <hadess@writeme.com>\nMaintained by A.Sleep <a.sleep@asleep.net>\n",
		   VERSION);
  
  DAInitialize(displayName, "wmpal", 50, 50, argc, argv);
  DASetCallbacks(&callbacks);
  
  DAMakePixmapFromData(wmpal_master_xpm, &pixmap, &mask, &height, &width);
  DAMakePixmapFromData(demon1_xpm, &pixanim1, &maskanim1, &height, &width);
  DAMakePixmapFromData(demon2_xpm, &pixanim2, &maskanim2, &height, &width);
  DAMakePixmapFromData(demon3_xpm, &pixanim3, &maskanim3, &height, &width);

  /* FIXME add more size checking, and file existance checks */

  gc = DefaultGC(DADisplay, DefaultScreen(DADisplay));
  
  DASetPixmap(pixmap);
  DAShow();
  
  while (1) {
    XEvent ev;
    
    if (anim_pos==0)
      {
	XCopyArea(DADisplay, pixanim1, pixmap, gc, 0, 0, 48, 48, 1, 1);
	anim_pos=1;
      }
    else if (anim_pos==1)
      {
	XCopyArea(DADisplay, pixanim2, pixmap, gc, 0, 0, 48, 48, 1, 1);
	anim_pos=2;
      }
    else if (anim_pos==2)
      {
	XCopyArea(DADisplay, pixanim3, pixmap, gc, 0, 0, 48, 48, 1, 1);
	anim_pos=0;
      }
    DASetPixmap(pixmap);
    
    /* handle all pending X events */
    while (XPending(DADisplay)) {
      XNextEvent(DADisplay, &ev);
      DAProcessEvent(&ev);
    }
    
    srand(time(&t));

    sleep(rand() % n + 1);

  }
  
  return 0;
}
