/* -*- C++ -*- */
/* $Id: xsay.c,v 1.2 2001/04/13 00:12:14 asleep Exp $ */
/* src/xsay.c */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#ifdef HAVE_GETOPT_LONG
#  include <getopt.h>
#endif

#include <gtk/gtk.h>

#define VERTEXT "XSay\n"			\
		"Copyright (C) 2000 Thomas Leonard.\n"			\
		"XSay comes with ABSOLUTELY NO WARRANTY,\n"	\
		"to the extent permitted by law.\n"			\
		"You may redistribute copies of XSay\n"		\
		"under the terms of the GNU General Public License.\n"	\
		"For more information about these matters, "		\
		"see the file named COPYING.\n"

#define HELP "Usage: xsay [OPTION]... [MESSAGE]\n"		\
       "Open a box displaying MESSAGE, or standard input if no message\n" \
       "is given.\n"							\
       "  -h, --help		display this help and exit\n"		\
       "  -b, --button=LABEL	create a button with this label\n"	\
       "  -t, --title=TITLE	use this as the window title\n"		\
       "  -v, --version		display the version information and exit\n"\
       "\n"	SHORT_ONLY_WARNING					\
       "Report bugs to <tal197@ecs.soton.ac.uk>.\n"

#ifdef HAVE_GETOPT_LONG
#  define USAGE   "Try `xsay --help' for more information.\n"
#  define SHORT_ONLY_WARNING ""
#else
#  define USAGE   "Try `xsay -h' for more information.\n"
#  define SHORT_ONLY_WARNING		\
		"NOTE: Your system does not support long options - \n"	\
		"you must use the short versions instead.\n\n"
#endif

static GtkWidget	*window, *text;
static gint		input_tag = -1;
static GList		*buttons = NULL;
static int		exit_status = 127;
static gboolean		option_print = FALSE;

/* Static prototypes */
static void data_ready(gpointer data, int fd, GdkInputCondition condition);
static void button_clicked(GtkWidget *button, int n);

#define SHORT_OPS "hb:pt:v"

#ifdef HAVE_GETOPT_LONG
static struct option long_opts[] =
{
	{"help", 0, NULL, 'h'},
	{"button", 1, NULL, 'b'},
	{"print", 0, NULL, 'p'},
	{"title", 1, NULL, 't'},
	{"version", 0, NULL, 'v'},
	{NULL, 0, NULL, 0},
};
#endif

#define ARG_VALUE (*optarg == '=' ? optarg + 1 : optarg)

guchar	*title = "XSay";

int main(int argc, char **argv)
{
	GtkWidget	*sb, *hbox, *vbox;
	guchar		*message = NULL;
	GList		*next;
	int		n;

	gtk_init(&argc, &argv);

	while (1)
	{
		int	c;
		
#ifdef HAVE_GETOPT_LONG
		int	long_index;
		c = getopt_long(argc, argv, SHORT_OPS, long_opts, &long_index);
#else
		c = getopt(argc, argv, SHORT_OPS);
#endif

		if (c == EOF)
			break;		/* No more options */
		
		switch (c)
		{
			case 'v':
				fputs(VERTEXT, stderr);
				return EXIT_SUCCESS;
			case 'b':
				buttons = g_list_append(buttons,
						g_strdup(ARG_VALUE));
				break;
			case 'p':
				option_print = TRUE;
				break;
			case 't':
				title = ARG_VALUE;
				break;
			case 'h':
				fputs(HELP, stderr);
				return EXIT_SUCCESS;
			default:
				fputs(USAGE, stderr);
				return EXIT_FAILURE;
		}
	}

	if (!buttons)
		buttons = g_list_append(buttons, "OK");

	window = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_default_size(GTK_WINDOW(window), 300, 64);
	gtk_signal_connect_object(GTK_OBJECT(window), "destroy",
		GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
	
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(window), vbox);
	
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);
	
	text = gtk_text_new(NULL, NULL);
	gtk_box_pack_start(GTK_BOX(hbox), text, TRUE, TRUE, 0);

	sb = gtk_vscrollbar_new(GTK_TEXT(text)->vadj);
	gtk_box_pack_start(GTK_BOX(hbox), sb, FALSE, TRUE, 0);

	hbox = gtk_hbox_new(TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 4);
	n = 0;
	for (next = buttons; next; next = next->next, n++)
	{
		guchar		*label = (guchar *) next->data;
		GtkWidget	*button;

		button = gtk_button_new_with_label(label);

		gtk_signal_connect(GTK_OBJECT(button), "clicked",
				GTK_SIGNAL_FUNC(button_clicked),
				(gpointer) n);

		gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, TRUE, 8);
		if (n == 0)
			gtk_widget_grab_focus(button);
	}

	if (optind < argc)
	{
		message = g_strjoinv(" ", argv + optind);

		gtk_window_set_title(GTK_WINDOW(window), title);

		gtk_text_insert(GTK_TEXT(text), NULL, NULL, NULL,
				message, -1);
	}
	else
	{
		input_tag = gdk_input_add(STDIN_FILENO, GDK_INPUT_READ,
						data_ready, NULL);
		message = g_strdup_printf("%s (...)", title);
		gtk_window_set_title(GTK_WINDOW(window), message);
	}

	g_free(message);

	gtk_widget_show_all(window);

	gtk_main();

	return exit_status;
}

static void data_ready(gpointer data, int fd, GdkInputCondition condition)
{
	guchar	buffer[2];
	int	got;
	
	got = read(fd, buffer, sizeof(buffer));

	if (got < 0)
		g_error("read(): %s\n", g_strerror(errno));

	if (got == 0)
	{
		gtk_window_set_title(GTK_WINDOW(window), title);
		gdk_input_remove(input_tag);
		return;
	}

	gtk_text_insert(GTK_TEXT(text), NULL, NULL, NULL,
			buffer, got);

	return;
}

static void button_clicked(GtkWidget *button, int n)
{
	if (option_print)
		g_print("%s\n", (guchar *) g_list_nth_data(buttons, n));
	exit_status = n;
	gtk_main_quit();
}
