
/*
 * wmpiki
 *
 * Copyright (C) 2002,2003 pasp and sill
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <unistd.h>

#include <sys/wait.h>
#include <sys/param.h>
#include <sys/types.h>

#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>

#include "docklib.h"

#include "master.h"
#include "mask.h"

#define MAX_HOSTS			8
#define MAX_PERIOD			1200
#define LED_COLORS			10
#define	MAX_BUFFER_SIZE		256
#define MAX_STR_LEN			10
#define CHECK_TIME			15
#define FALSE				0
#define TRUE				1

typedef struct {
	char host[MAX_VALUE_LEN];
	char alias[MAX_VALUE_LEN];
	int check_period;
	int led;
} wmph;

wmph wmp_hosts[MAX_HOSTS];

int small_font;
int disable_head;
char ping_options[MAX_VALUE_LEN];
char ping_grep[MAX_VALUE_LEN];

int defined_hosts[MAX_HOSTS];
int nrofhosts;
/*----------------------------------------------------------------------*/

void wmpiki_put_char(int x, int y, char z)
{
char *ctable = { "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890" };
int k, f, l;

	l = strlen(ctable);

	for(k=f=0;k<l;k++)
		if(toupper(z)==ctable[k]) { f = 1; break; }

	if(f) {
		if(k < 12) 
			copyXPMArea(k*5, 69, 5, 5, x, y);
		else if(k < 24) 
			copyXPMArea((k-12)*5, 74, 5, 5, x, y);
		else
			copyXPMArea((k-24)*5, 79, 5, 5, x, y);
	}
}

/*----------------------------------------------------------------------*/

void wmpiki_put_char_small(int x, int y, char z)
{
char *ctable = { "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890.[]-_:'" };
int k, f, l;

	l = strlen(ctable);

	for(k=f=0;k<l;k++)
		if(toupper(z)==ctable[k]) { f = 1; break; }

	if(f) {
		if(k < 16) 
			copyXPMArea(k*4, 84, 4, 5, x, y);
		else if(k < 32) 
			copyXPMArea((k-16)*4, 89, 4, 5, x, y);
		else
			copyXPMArea((k-32)*4, 94, 4, 5, x, y);
	}
}

/*----------------------------------------------------------------------*/

int wmpiki_check_host(char *hostname)
{
FILE *cmdpipe;
char linebuffer[MAX_BUFFER_SIZE], commandbuffer[MAX_BUFFER_SIZE];
int  ret;

	strcpy(commandbuffer, "ping ");
	strcat(commandbuffer, hostname);
	strcat(commandbuffer, " ");
	strcat(commandbuffer, ping_options);
	strcat(commandbuffer, " | grep '");
	strcat(commandbuffer, ping_grep);
	strcat(commandbuffer, "'");

    cmdpipe = popen(commandbuffer, "r");
    linebuffer[0] = '\0';
    fscanf (cmdpipe, "%[^\n]", linebuffer);
    ret = !pclose(cmdpipe);
    return ret;
}

/*----------------------------------------------------------------------*/

void wmpiki_routine(int argc, char **argv)
{
XEvent Event;
long starttime, curtime, nexttime[MAX_HOSTS];
int xpm_X=0, xpm_Y=0, i, j;

int ypos = 21;
int fnth = 5; 
int nohole = 0;

int ypos_tab[8] = { 28, 25, 23, 20, 17, 9, 9, 9 };
int fnth_tab[8] = {  6,  6,  5,  4,  3, 3, 2, 1 };

	ypos = ypos_tab[nrofhosts-1];
	fnth += fnth_tab[nrofhosts-1]; 

	openXwindow(argc, argv, wmpiki_master_xpm, wmpiki_mask_bits, wmpiki_mask_width, wmpiki_mask_height);

	if (nrofhosts>=6)
		copyXPMArea(0, 99, 56, 9, 4, 5); 
    else if (disable_head) {
		ypos-=5; 
		fnth+=1; 
		copyXPMArea(0, 99, 56, 9, 4, 5); 
	}

	for(i=0;i<MAX_HOSTS;i++)
		if(small_font) 
			wmp_hosts[i].alias[MAX_STR_LEN-1] = '\0';
		else 
			wmp_hosts[i].alias[MAX_STR_LEN-3] = '\0';

	starttime = time(0);              
	for(i=0;i<MAX_HOSTS;i++)
		nexttime[i] = starttime + wmp_hosts[i].check_period;

	/* show aliases */
	for(i=nohole=0;i<MAX_HOSTS;i++) {
		if(defined_hosts[i]==TRUE) {
			for(j=0;j<MAX_STR_LEN;j++)
				if(small_font) wmpiki_put_char_small(14+j*5, ypos+nohole*fnth, wmp_hosts[i].alias[j]);
				else wmpiki_put_char(15+j*6, ypos+nohole*fnth, wmp_hosts[i].alias[j]);
			nohole++;
		}
	}

	/* show leds */
	for(i=nohole=0;i<MAX_HOSTS;i++) {
		if(defined_hosts[i]==TRUE) {
			copyXPMArea(0, 64, 5, 5, 6, ypos+nohole*fnth);
			nohole++;
		}
	}

	i = 1;

	while(i)
		while (XPending(display)) {
			XNextEvent(display, &Event);
            if(Event.type == Expose) {
				RedrawWindowXY(xpm_X, xpm_Y);
				i = 0;
			}
		}

	/* check hosts */
	for(i=nohole=0;i<MAX_HOSTS;i++) {
		if(defined_hosts[i]==TRUE) {
			if(wmpiki_check_host(wmp_hosts[i].host))
				copyXPMArea(0+5*wmp_hosts[i].led, 64, 5, 5, 6, ypos+nohole*fnth);
			nohole++;
		}
	}


	while (1) {
		curtime = time(0);

		waitpid(0, NULL, WNOHANG);

		for(i=nohole=0;i<MAX_HOSTS;i++)
			if(defined_hosts[i]==TRUE) {
				if (curtime >= nexttime[i]) {
					nexttime[i]+=wmp_hosts[i].check_period;

					copyXPMArea(0, 64, 5, 5, 6, ypos+nohole*fnth);

					if(wmpiki_check_host(wmp_hosts[i].host))
						copyXPMArea(0+5*wmp_hosts[i].led, 64, 5, 5, 6, ypos+nohole*fnth);
				}
				nohole++;
			}
	
		RedrawWindowXY(xpm_X, xpm_Y);

		while (XPending(display)) {
			XNextEvent(display, &Event);
			switch (Event.type) {
			case Expose:
				RedrawWindowXY(xpm_X, xpm_Y);
				break;
			case DestroyNotify:
				XCloseDisplay(display);
				exit(0);
				break;
			}
		}

		usleep(250000L);
	}
}

/*----------------------------------------------------------------------*/

void wmpiki_write_prefs(void) 
{
int i;
char tmpbuffer[64];

	if (p_prefs_openfile (p_getfilename_config (".clay", "wmpiki"), P_WRITE)) {
    
		for(i=0;i<MAX_HOSTS;i++) {
			sprintf(tmpbuffer, "host%d", i+1);
			p_prefs_put_string (tmpbuffer, wmp_hosts[i].host);
			sprintf(tmpbuffer, "host%d_alias", i+1);
			p_prefs_put_string (tmpbuffer, wmp_hosts[i].alias);
			sprintf(tmpbuffer, "host%d_update_period", i+1);
			p_prefs_put_int(tmpbuffer, wmp_hosts[i].check_period);
			sprintf(tmpbuffer, "host%d_led_color", i+1);
			p_prefs_put_int(tmpbuffer, wmp_hosts[i].led);
			p_prefs_put_lf ();
    	}

		p_prefs_put_int ("small_font", small_font);
		p_prefs_put_int ("disable_head", disable_head);
		p_prefs_put_string ("ping_options", ping_options);
		p_prefs_put_string ("ping_grep", ping_grep);

	}
        
	p_prefs_closefile ();
}

/*----------------------------------------------------------------------*/

void wmpiki_read_prefs(void) 
{
int i;
char tmpbuffer[64];

	nrofhosts=0;

	if (p_prefs_openfile (p_getfilename_config(".clay", "wmpiki"), P_READ)) {

		for(i=0;i<MAX_HOSTS;i++) defined_hosts[i] = FALSE;

		for(i=0;i<MAX_HOSTS;i++) {
			sprintf(tmpbuffer, "host%d", i+1);
			strcpy(wmp_hosts[i].host, p_prefs_get_string (tmpbuffer));
			if (isalnum(wmp_hosts[i].host[0])) {
				defined_hosts[i] = TRUE;
				nrofhosts++;
			}
			sprintf(tmpbuffer, "host%d_alias", i+1);
			strcpy(wmp_hosts[i].alias, p_prefs_get_string (tmpbuffer));
			sprintf(tmpbuffer, "host%d_update_period", i+1);
			wmp_hosts[i].check_period = p_prefs_get_int(tmpbuffer);
			sprintf(tmpbuffer, "host%d_led_color", i+1);
			wmp_hosts[i].led = p_prefs_get_int(tmpbuffer) % LED_COLORS;
			if(!wmp_hosts[i].led) wmp_hosts[i].led = 1;
		}

		small_font = p_prefs_get_int("small_font");
		disable_head = p_prefs_get_int("disable_head");
		strcpy(ping_options, p_prefs_get_string ("ping_options"));
		strcpy(ping_grep, p_prefs_get_string ("ping_grep"));
    
		p_prefs_closefile ();
        
	} else {

		nrofhosts = 4;

		for(i=0;i<nrofhosts;i++) {
			defined_hosts[i] = TRUE;
			strcpy(wmp_hosts[i].host, "localhost");
			strcpy(wmp_hosts[i].alias, "local");
		}

		for(i=0;i<MAX_HOSTS;i++) {
			wmp_hosts[i].check_period = 120;
			wmp_hosts[i].led = 1;
		}

		small_font = 0;
		disable_head = 0;
		strcpy(ping_options, "-c 1 -w 1");
		strcpy(ping_grep, "bytes from");

		wmpiki_write_prefs ();

	}
}

/*----------------------------------------------------------------------*/

int main(int argc, char **argv)
{
	wmpiki_read_prefs(); 
	wmpiki_routine(argc, argv);
	return 0;
}

