#ifndef INCLUDED_WMSTOCK_H
#define INCLUDED_WMSTOCK_H

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <regex.h>
#include <time.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <ctype.h>
#include <errno.h>
#include <signal.h>
#include <X11/X.h>
#include <X11/xpm.h>
#include "getopt.h"
#include "xutils.h"

#define DELAY 300000L

/* all these are now modifiable via the command line */
#define DOWNLOAD_DELAY 0		/* time in seconds it will take to
					download and process the file,
					try 20-30 for a modem */

#define DEFAULT_TIME_BETWEEN 10		/* seconds between changing to the
					next ticker symbol */

#define DEFAULT_UPDATEDELAY 300		/* seconds until the quote becomes
					stale, ie. seconds until its time
					to download new data for the quote 
					THIS IS CHANGABLE VIA -delay on the
					command line */

#define WMSTOCK_VERSION "0.10"
#define RELEASE_DATE "October 28, 1999"

typedef struct ticker_struct ticker_struct;

struct ticker_struct
{
	char ticker[8];
	char company_name[32];
	char last_trade_date[10];
	char last_trade_time[10];
	char change[8];
	char percent_change[32]; 
	char bid[10];
	char ask[10];
	char days_range[32];
	char fifty_two_week_range[32];
	char div_date[10];
	char market_cap[24];

	double last_price;
	double previous_close;
	double open;
	double eps;
	double pe_ratio;
	double div_per_share;
	double div_yield;

	long volume;
	long average_volume;
	
	struct timeval oldtime, newtime;
	long timediff;
};

#include "ll.h"

void ParseCMDLine(int argc, char *argv[]);
void display_error(int errornum);
void display_data(struct ticker_struct);
void reset_ticker(struct ticker_struct);
int get_data_from_file(char [], char []);
void download_data(char []);
void ButtonPressEvent(XButtonEvent *xev);
void mySignalHandler(int signal_number);
void drawstring(char [], int xoffset, int yrow, int ypos);
int are_markets_open();

#endif
