%define pref 	%{_prefix}
%define python 	/usr/bin/python2.2
%define pyver 	2.2
%define port  	GTK
%define lcport 	gtk
%define unicode 0
%define tarname wxPythonSrc
%define version 2.4.2.4
%define ver2    2.4
%define release 1
%define wxprefbase %{pref}/lib/wxPython
%define wxpref  %{wxprefbase}-%{version}
%define name    wxPython%{port}-py%{pyver}


# Should the builtin image and etc. libs be used, or system libs?
# Distro specific RPMs should probably set this to 0, generic ones
# should use 1
%define builtin_libs 1


# Should --enable-debug_flag be used in release builds?  Using it
# defines __WXDEBUG__ and gives us runtime diagnostics that are turned
# into Python exceptions starting with 2.3.4.  (So turning it on is a
# very helpful thing IMO and is recommended.)
%define debug_flag 1


# build the name of the real wx-config from the port, flags, etc.
%define dbgflg %(if [ "%{debug_flag}" = "1" ]; then echo d; fi)
%define uniflg %(if [ "%{unicode}" = "1" ]; then echo u; fi)
%define DBGFLG %(if [ "%{debug_flag}" = "1" ]; then echo D; fi)
%define UNIFLG %(if [ "%{unicode}" = "1" ]; then echo U; fi)
%define wxconfigname %{wxpref}/bin/wx%{lcport}%{uniflg}%{dbgflg}-%{ver2}-config

# turn off the generation of debuginfo rpm  (RH9)
%define debug_package %{nil}

#----------------------------------------------------------------
Summary:   Cross platform GUI toolkit for Python using wx%{port}
Name:      %{name}
Version:   %{version}
Release:   %{release}
Source0:   %{tarname}-%{version}.tar.gz
License:   wxWindows Library Licence, Version 3
URL:       http://wxPython.org/
Packager:  Robin Dunn <robin@alldunn.com>
Group:     Development/Python
BuildRoot: %{_tmppath}/%{name}-buildroot
Prefix:    %{pref}

Provides: wxPython  = %{version}
Provides: wxPython%{port}  = %{version}

Provides: libwx_%{lcport}%{uniflg}%{dbgflg}-%{ver2}.so
Provides: libwx_%{lcport}%{uniflg}%{dbgflg}-%{ver2}.so(WX%{port}%{UNIFLG}%{DBGFLG}_%{ver2})
Provides: libwx_%{lcport}%{uniflg}%{dbgflg}_gl-%{ver2}.so
Provides: libwx_%{lcport}%{uniflg}%{dbgflg}_gl-%{ver2}.so(WX%{port}%{UNIFLG}%{DBGFLG}_%{ver2})


# old wxPython packages
Obsoletes: wxPython wxPython%{port}


%description
wxPython is a GUI toolkit for Python that is a wrapper around the
wxWindows C++ GUI library.  wxPython provides a large variety of
window types and controls, all implemented with a native look and feel
(and native runtime speed) on the platforms it is supported on.

This package is implemented using the %{port} port of wxWindows, and
includes the wx%{port} shared libs and etc.


%package -n wxPython%{port}-devel
Summary: wxPython%{port} development files
Group: Development/Libraries
Requires: wxPython%{port} = %{version}


%description -n wxPython%{port}-devel
This packages contains the headers and etc. for building apps or
Python extension modules that use the same wx%{port} shared libraries
that wxPython uses.

#----------------------------------------------------------------
%prep
%setup -q -n %{tarname}-%{version}


#----------------------------------------------------------------
%build
if [ "$SMP" != "" ]; then
    MAKE="make -j$SMP"
else
    MAKE="make"
fi

WXDIR=`pwd`
mkdir build
cd build

# Configure, trying to reduce external dependencies
$WXDIR/configure --with-%{lcport} \
	--prefix=%{wxpref} \
	--disable-soname \
	--enable-rpath=%{wxpref}/lib \
	--with-opengl \
%if %{unicode}
	--enable-gtk2 \
	--enable-unicode \
%endif
	--enable-geometry \
	--enable-optimise \
%if %{debug_flag}
	--enable-debug_flag \
%endif
%if %{builtin_libs}
	--with-libjpeg=builtin \
	--with-libpng=builtin \
	--with-libtiff=builtin \
	--with-zlib=builtin \
%endif


# Build wxWindows
$MAKE


# Now build wxPython
cd $WXDIR/wxPython
%{python} setup.py \
	IN_CVS_TREE=1 \
	NO_SCRIPTS=1 \
	WXPORT=%{lcport} \
	UNICODE=%{unicode} \
	WX_CONFIG="$WXDIR/build/wx-config --prefix=$WXDIR --exec-prefix=$WXDIR/build" \
	build



# Build wxrc (XRC resource tool) but don't use the makefiles since they expect
# a shared version of the xrc lib to have been built...
cd $WXDIR/contrib/utils/wxrc
WX_CONFIG="$WXDIR/build/wx-config --prefix=$WXDIR --exec-prefix=$WXDIR/build"
wCC=`$WX_CONFIG --cc`
wCXX=`$WX_CONFIG --cxx`

for f in wxrc.cpp ../../src/xrc/xml.cpp ../../src/xrc/xmlres.cpp; do
    echo $f
    $wCXX `$WX_CONFIG --cxxflags` -I ../../include -I ../../src/xrc/expat/xmlparse -I ../../src/xrc/expat/xmltok -c $f
done
for f in ../../src/xrc/expat/xmlparse/xmlparse.c ../../src/xrc/expat/xmltok/xmlrole.c ../../src/xrc/expat/xmltok/xmltok.c; do
    echo $f
    $wCC `$WX_CONFIG --cxxflags` -I ../../include -I ../../src/xrc/expat/xmlparse -I ../../src/xrc/expat/xmltok -c $f
done

$wCXX `$WX_CONFIG --libs` *.o -o wxrc
strip wxrc


#----------------------------------------------------------------
%install
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

# install wxWindows
WXDIR=`pwd`
cd build
make prefix=$RPM_BUILD_ROOT%{wxpref} install

# install wxPython
cd $WXDIR/wxPython
%{python} setup.py \
	IN_CVS_TREE=1 \
	NO_SCRIPTS=1 \
	WXPORT=%{lcport} \
	UNICODE=%{unicode} \
	WX_CONFIG="$RPM_BUILD_ROOT%{wxpref}/bin/wx-config --prefix=$RPM_BUILD_ROOT%{wxpref}" \
	install \
	--root=$RPM_BUILD_ROOT

# Since I want this RPM to be as generic as possible I won't let
# distutils copy the scripts since it will mangle the #! line to use
# the real python pathname.  Since some distros install python 2.2 as
# python2 and others as python, then I can't let distutils do that
# otherwise the dependencies will be fouled up.  Copy them manually
# instead, leaving the #!/bin/env line intact.
#
# TODO:  Should this be dependent on %{builtin_libs} or something like it?

mkdir -p $RPM_BUILD_ROOT%{pref}/bin
for s in \
	helpviewer \
	img2png \
	img2py \
	img2xpm \
	pyalacarte \
	pyalamode \
	pycrust \
	pywrap \
	pyshell \
	xrced; do
    cp scripts/$s $RPM_BUILD_ROOT%{pref}/bin
done


# Install wxrc
cp $WXDIR/contrib/utils/wxrc/wxrc $RPM_BUILD_ROOT%{pref}/bin


# link specific name to generic name
ln -s wxPython-%{version} $RPM_BUILD_ROOT%{wxprefbase}



# Copy icons and make menu entries
#-- This only works for Mandrake.  Is there a cross-distro way to do it?
##mkdir -p $RPM_BUILD_ROOT%{_iconsdir}
##mkdir -p $RPM_BUILD_ROOT%{_miconsdir}
##mkdir -p $RPM_BUILD_ROOT%{_menudir}
##install -p -m 644 $WXDIR/wxPython/wxPython/py/PyCrust_32.png $RPM_BUILD_ROOT%{_iconsdir}/PyCrust.png
##install -p -m 644 $WXDIR/wxPython/wxPython/py/PyCrust_16.png $RPM_BUILD_ROOT%{_miconsdir}/PyCrust.png
##install -p -m 644 $WXDIR/wxPython/wxPython/tools/XRCed/XRCed_32.png $RPM_BUILD_ROOT%{_iconsdir}/XRCed.png
##install -p -m 644 $WXDIR/wxPython/wxPython/tools/XRCed/XRCed_16.png $RPM_BUILD_ROOT%{_miconsdir}/XRCed.png
##
##cat > $RPM_BUILD_ROOT%{_menudir}/%{name} <<EOF
##?package(%{name}): command="%_bindir/pyshell" needs="X11" \
##icon="PyCrust.png" section="Applications/Development" \
##title="PyShell" longtitle="Python Shell"
##
##?package(%{name}): command="%_bindir/pycrust" needs="X11" \
##icon="PyCrust.png" section="Applications/Development" \
##title="PyCrust" longtitle="Python Shell with Filling"
##
##?package(%{name}): command="%_bindir/pyalamode" needs="X11" \
##icon="PyCrust.png" section="Applications/Development" \
##title="PyAlaMode" longtitle="Python Shell with Filling and editor windows"
##
##?package(%{name}): command="%_bindir/xrced" needs="X11" \
##icon="XRCed.png" section="Applications/Development" \
##title="XRCed" longtitle="wxPython XRC resource editor"
##
##EOF



# Generate the filelists.  For some reason the %defattr below is still
# resulting in many (but not all) files not owned by root when just
# specifying directories and wildcards to be included in each package.
# So instead we'll build some explicit filelists here and use %attr on
# each entry.
cd $WXDIR
mkdir -p $RPM_BUILD_ROOT%{pref}/share/doc
GFL="%{python} wxPython/distrib/genfilelist.py"
$GFL    $RPM_BUILD_ROOT %{pref}                     > FILELIST
$GFL -r $RPM_BUILD_ROOT %{pref}/bin                >> FILELIST
$GFL    $RPM_BUILD_ROOT %{pref}/lib                >> FILELIST
$GFL -r $RPM_BUILD_ROOT %{pref}/lib/python%{pyver} >> FILELIST
$GFL -r $RPM_BUILD_ROOT %{pref}/share              >> FILELIST
$GFL    $RPM_BUILD_ROOT %{wxpref}                  >> FILELIST
$GFL    $RPM_BUILD_ROOT %{wxprefbase}              >> FILELIST
$GFL    $RPM_BUILD_ROOT %{wxpref}/lib              >> FILELIST
$GFL    $RPM_BUILD_ROOT "%{wxpref}/lib/libwx*"     >> FILELIST
$GFL -r $RPM_BUILD_ROOT %{wxpref}/share            >> FILELIST
###GFL -r $RPM_BUILD_ROOT %{_iconsdir}               >> FILELIST
##$GFL -r $RPM_BUILD_ROOT %{_menudir}                >> FILELIST

$GFL    $RPM_BUILD_ROOT %{wxpref}/include           > DEVELLIST
$GFL -r $RPM_BUILD_ROOT %{wxpref}/include/wx       >> DEVELLIST
$GFL -r $RPM_BUILD_ROOT %{wxpref}/lib/wx           >> DEVELLIST
$GFL    $RPM_BUILD_ROOT %{wxconfigname}            >> DEVELLIST
$GFL    $RPM_BUILD_ROOT %{wxpref}/bin/wx-config    >> DEVELLIST


#----------------------------------------------------------------
##%post
##%{update_menus}
##
##%postun
##%{clean_menus}


%pre
if [ -e %{wxprefbase} ]; then
	rm -r %{wxprefbase}
fi

%postun
if [ -e %{wxprefbase} ]; then
	rm %{wxprefbase}
fi

#----------------------------------------------------------------
%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT


#----------------------------------------------------------------

%files -f FILELIST
%defattr(-,root,root)
%doc docs/preamble.txt docs/licence.txt docs/readme.txt docs/changes.txt
%doc wxPython/README.txt wxPython/CHANGES.txt
%doc wxPython/docs/*

%files -n wxPython%{port}-devel -f DEVELLIST
%defattr(-,root,root)


#----------------------------------------------------------------
# end of file
