<?php
/**
 * Exception Handling System
 *
 * @package exceptions
 * @copyright (C) 2003 by the Xaraya Development Team.
 * @license GPL <http://www.gnu.org/licenses/gpl.html>
 * @link http://www.xaraya.com
 * @author Marc Lutolf <marcinmilan@xaraya.com>
 */

    $this->defaults = array(
        'ASSERT_FAILURE' => array(
            'title' => xarML('Assertion in code failed'),
            'short' => xarML('An assertion evaluated to false, which indicates a coding error.'),
            'long' => xarML('While executing, an asserted condition failed. This means that a definite error in some code exists.')),
        'BAD_PARAM' => array(
            'title' => xarML('Bad Parameter'),
            'short' => xarML('A parameter encountered was bad.'),
            'long' => xarML('A parameter provided during this operation could not be validated, or was not accepted for other reasons.') ),
        'COMPILER ERROR' => array(
            'title' => xarML('Compiler error'),
            'short' => xarML('The Blocklayout compiler encountered an error.'),
            'long' => xarML('The Blocklayout compiler encountered an error it could not recover from. No specific information is available.') ),
        'CONFIG_ERROR' => array(
        'title' => xarML('Xaraya is not properly configured'),
            'short' => xarML('The combination of configuration settings has led to a conflict'),
            'long'  => xarML('Xaraya is configured with some settings which lead to a conflicting situation. Some configuration settings cannot be used simultaneously') ),        
        'CONTEXT_NOT_EXIST' => array(
            'title' => xarML('Context does not exist'),
            'short' => xarML('A context element was not found.'),
            'long' => xarML('This error is a catchall to describe situations where a context element (block, template, include) was expected but not found.') ),
        'DATABASE_ERROR' => array(
            'title' => xarML('Database Error'),
            'short' => xarML('An error was encountered while attempting a database operation.'),
            'long' => xarML('No further information is available.') ),
        'DATABASE_ERROR_QUERY' => array(
            'title' => xarML('Database Query Error'),
            'short' => xarML('An error was encountered while trying to execute a database query.'),
            'long' => xarML('A database query could not be executed, either because the query could not be understood or because it returned unexpected results.') ),
        'DEPRECATED_API' => array(
            'title' => xarML('Deprecated API'),
            'short' => xarML('A function call encountered belongs to a deprecated API.'),
            'long' => xarML('A function call encountered belongs to an old API and is therefore no longer supported.') ),
        'DEPRECATED_ATTRIBUTE' => array(
            'title' => xarML('Deprecated Blocklayout Attribute'),
            'short' => xarML('A tag in a template contains a deprecated attribute.'),
            'long' => xarML('A tag in a template contains a deprecated attribute and needs to be replaced by a new one, or be left out, see BL documentation for the right syntax.') ),
        'E_ERROR' => array(
            'title' => xarML('PHP: Fatal Error'),
            'short' => xarML('A system error was received from the PHP interpreter.'),
            'long' => xarML('There is an error in the PHP code that is being processed.')),
        'E_WARNING' => array(
            'title' => xarML('PHP: Warning'),
            'short' => xarML('A system error was received from the PHP interpreter.'),
            'long' => xarML('There is an error in the PHP code that is being processed.')),
        'E_PARSE' => array(
            'title' => xarML('PHP: Parse Error'),
            'short' => xarML('A system error was received from the PHP interpreter.'),
            'long' => xarML('There is an error in the PHP code that is being processed.')),
        'E_NOTICE' => array(
            'title' => xarML('PHP: Error Notice'),
            'short' => xarML('A system error was received from the PHP interpreter.'),
            'long' => xarML('There is an error in the PHP code that is being processed.')),
        'E_CORE_ERROR' => array(
            'title' => xarML('PHP: Core Error'),
            'short' => xarML('A system error was received from the PHP interpreter.'),
            'long' => xarML('There is an error in the PHP code that is being processed.')),
        'E_CORE_WARNING' => array(
            'title' => xarML('PHP: Core Warning'),
            'short' => xarML('A system error was received from the PHP interpreter.'),
            'long' => xarML('There is an error in the PHP code that is being processed.')),
        'E_COMPILE_ERROR' => array(
            'title' => xarML('PHP: Compile Error'),
            'short' => xarML('A system error was received from the PHP interpreter.'),
            'long' => xarML('There is an error in the PHP code that is being processed.')),
        'E_COMPILE_WARNING' => array(
            'title' => xarML('PHP: Compile Warning'),
            'short' => xarML('A system error was received from the PHP interpreter.'),
            'long' => xarML('There is an error in the PHP code that is being processed.')),
        'E_USER_ERROR' => array(
            'title' => xarML('PHP: User Error'),
            'short' => xarML('A system error was received from the PHP interpreter.'),
            'long' => xarML('There is an error in the PHP code that is being processed.')),
        'E_USER_WARNING' => array(
            'title' => xarML('PHP: User Warning'),
            'short' => xarML('A system error was received from the PHP interpreter.'),
            'long' => xarML('There is an error in the PHP code that is being processed.')),
        'E_USER_NOTICE' => array(
            'title' => xarML('User Notice'),
            'short' => xarML('A system error was received from the PHP interpreter.'),
            'long' => xarML('There is an error in the PHP code that is being processed.')),
        'EMPTY_PARAM' => array(
            'title' => xarML('Empty Parameter'),
            'short' => xarML('A parameter value was not provided.'),
            'long' => xarML('A parameter was expected during this operation, but none was found.') ),
        'EVENT_NOT_REGISTERED' => array(
            'title' => xarML('Event is not registered'),
            'short' => xarML('An unknown event was encountered.'),
            'long' => xarML('A reference to an event was encountered that is unknown to the system.') ),
        'EXCEPTION_FAILURE' => array(
            'title' => xarML('Unknown system error'),
            'short' => xarML('An unknown system error was encountered.'),
            'long' => xarML('The error system has encountered an error it cannot identify. Please help us correct this by filing a bug at <a href="http://bugs.xaraya.com/enter_bug.cgi?product=App%20-%20Core">bugs.xaraya.com</a>.') ),
        'FUNCTION_FAILED' => array(
            'title' => xarML('Function failed'),
            'short' => xarML('A call to a function returned a bad result.'),
            'long' => xarML('The function executed correctly, but the result was a failure.') ),
        'ID_NOT_EXIST' => array(
            'title' => xarML('Unknown ID'),
            'short' => xarML('An expected ID was not found.'),
            'long' => xarML('An item was requested by an ID that is not recognized. This could mean the item has been moved, changed, or does not exist.') ),
        'INVALID_ATTRIBUTE' => array(
            'title' => xarML('Invalid attribute'),
            'short' => xarML('The Blocklayout parser encountered an invalid attribute.'),
            'long' => xarML('No further information is available.') ),
        'INVALID_ENTITY' => array(
            'title' => xarML('Invalid entity'),
            'short' => xarML('The Blocklayout parser encountered an invalid entity.'),
            'long' => xarML('No further information is available.') ),
        'INVALID_FILE' => array(
            'title' => xarML('Invalid file'),
            'short' => xarML('The Blocklayout parser encountered an invalid file.'),
            'long' => xarML('The file was either not found, or could not be read properly.') ),
        'INVALID_INSTRUCTION' => array(
            'title' => xarML('Invalid instruction'),
            'short' => xarML('The Blocklayout parser encountered an invalid instruction.'),
            'long' => xarML('No further information is available.') ),
        'INVALID_SPECIALVARIABLE' => array(
            'title' => xarML('Invalid special variable'),
            'short' => xarML('The Blocklayout parser encountered a problem with a special variable.'),
            'long' => xarML('No further information is available.') ),
        'INVALID_SYNTAX' => array(
            'title' => xarML('Invalid syntax'),
            'short' => xarML('The Blocklayout parser encountered a syntax error.'),
            'long' => xarML('No further information is available.') ),
        'INVALID_TAG' => array(
            'title' => xarML('Invalid tag'),
            'short' => xarML('The Blocklayout parser encountered an invalid tag.'),
            'long' => xarML('The tag encountered does not conform to XML syntax.') ),
        'LOCALE_NOT_AVAILABLE' => array(
            'title' => xarML('Locale not available') ),
        'LOCALE_NOT_EXIST' => array(
            'title' => xarML('Locale does not exist'),
            'short' => xarML('An unknown locale was encountered.'),
            'long' => xarML('A reference to a locale was encountered that is unknown to the system.') ),
        'MISSING_ATTRIBUTE' => array(
            'title' => xarML('Missing attribute'),
            'short' => xarML('The Blocklayout parser could not find a tag attribute.'),
            'long' => xarML('A tag attribute required by syntax was not found.') ),
        'MISSING_PARAMETER' => array(
            'title' => xarML('Missing parameter'),
            'short' => xarML('The Blocklayout parser could not resolve a tag parameter.'),
            'long' => xarML('A tag parameter could not be resolved because of bad syntax.') ),
        'MODULE_DEPENDENCY' => array(
            'title' => xarML('Module Dependency'),
            'short' => xarML('A module call failed because of an unsatisifed dependency.'),
            'long' => xarML('The current module cannot execute because another module that must first be installed is not present.') ),
        'MODULE_FILE_NOT_EXIST' => array(
            'title' => xarML('Module file does not exist'),
            'short' => xarML('An operation requires a module file that cannot be found.'),
            'long' => xarML('The file may be missing, or its name may have changed. Note: this error sometimes also occurs when a file cannot be parsed because of PHP errors.')),
        'MODULE_FUNCTION_NOT_EXIST' => array(
            'title' => xarML('Module function does not exist'),
            'short' => xarML('A call has been made to a module function that cannot be found.'),
            'long' => xarML('The file in which the function was expected may be missing. If not, then the error may have occurred because the actual function has a different name, or does not exist. Note: this error sometimes also occurs when a file cannot be parsed because of PHP errors.')),
        'MODULE_NOT_ACTIVE' => array(
            'title' => xarML('Module is not active'),
            'short' => xarML('A call has been made to a module that is not active.'),
            'long' => xarML('A module was called that has not yet been activated/installed. Use the activate link in the modules module (Modules->ViewAll) to install modules.')),
        'MODULE_NOT_EXIST' => array(
            'title' => xarML('Module does not exist'),
            'short' => xarML('A call has been made to a module that cannot be found'),
            'long' => xarML('A module was called that has not yet been installed or is not present. Use the activate link in the modules module (Modules->ViewAll) to install modules. Note: this error sometimes also occurs when a file cannot be parsed because of PHP errors.')),
        'NO_PERMISSION' => array(
            'title' => xarML('No Privilege'),
            'short' => xarML('You do not have the privileges for this operation.'),
            'long' => xarML('An operation was attempted for which your user has not been assigned privileges. Privileges must be assigned by the system administrator(s).')),
        'NOT_IMPLEMENTED' => array(
            'title' => xarML('Not implemented'),
            'short' => xarML('The requested feature is not available.'),
            'long' => xarML('A request was made to access a feature that is not available in this installation. The feature is either missing or unavailable in the current version of Xaraya.')),
        'SYSTEM_ERROR' => array(
            'title' => xarML('System error'),
            'short' => xarML('A system error was encountered.'),
            'long' => xarML('No further information is available.')),
        'TEMPLATE_NOT_EXIST' => array(
            'title' => xarML('Template does not exist'),
            'short' => xarML('An unknown template name was encountered.'),
            'long' => xarML('An attempt was made to render a template that was not found. The template may have been removed or does not exist, or its name may have changed.') ),
        'THEME_NOT_EXIST' => array(
            'title' => xarML('Theme does not exist'),
            'short' => xarML('An unknown theme name was encountered.'),
            'long' => xarML('An attempt was made to display a theme that was not found. The theme may have been removed or does not exist, or its name may have changed.') ),
        'UNABLE_TO_LOAD' => array(
            'title' => xarML('Unable to load'),
            'short' => xarML('An error was encountered during a load operation.'),
            'long' => xarML('The system was unable to successfully load a component, such as a module or theme.') ),
        'UNKNOWN' => array(
            'title' => xarML('Unknown Error'),
            'short' => xarML('An unknown error was encountered.'),
            'long' => xarML('No further information is available.') ),
        'VARIABLE_NOT_REGISTERED' => array(
            'title' => xarML('Variable is not registered'),
            'short' => xarML('You are attempting to call a variable that the system does not recognize.'),
            'long' => xarML('An error was encountered during a call to a variable. The variable may have been removed, or its name changed.') ),
        'XML_PARSER_ERROR' => array(
            'title' => xarML('XML Parser Error'),
            'short' => xarML('The XML parser has encountered an error.'),
            'long' => xarML('The XML parser tried to execute a line that was not well formed.'))
    );
?>