
/* @(#)babymap.h	1.3 4/2/91 11:55:35 */

#include "squish.xbm"

#define BABY_HEADINGS	24	/* number of orientations */
#define BABY_ANGLE	15	/* angle between orientations */

typedef struct BabyMap {
	char *BabyBits;
	Pixmap pixmap;
	int width;
	int height;
	float sine;
	float cosine;
} BabyMap;

#include "baby/a_pic000.xbm"
#include "baby/a_pic045.xbm"
#include "baby/a_pic090.xbm"
#include "baby/a_pic135.xbm"
#include "baby/a_pic180.xbm"
#include "baby/a_pic225.xbm"
#include "baby/a_pic270.xbm"
#include "baby/a_pic315.xbm"

#include "baby/b_pic000.xbm"
#include "baby/b_pic045.xbm"
#include "baby/b_pic090.xbm"
#include "baby/b_pic135.xbm"
#include "baby/b_pic180.xbm"
#include "baby/b_pic225.xbm"
#include "baby/b_pic270.xbm"
#include "baby/b_pic315.xbm"

#if BABY_ANGLE == 15
#include "baby/a_pic015.xbm"
#include "baby/a_pic030.xbm"
#include "baby/a_pic060.xbm"
#include "baby/a_pic075.xbm"
#include "baby/a_pic105.xbm"
#include "baby/a_pic120.xbm"
#include "baby/a_pic150.xbm"
#include "baby/a_pic165.xbm"
#include "baby/a_pic195.xbm"
#include "baby/a_pic210.xbm"
#include "baby/a_pic240.xbm"
#include "baby/a_pic255.xbm"
#include "baby/a_pic285.xbm"
#include "baby/a_pic300.xbm"
#include "baby/a_pic330.xbm"
#include "baby/a_pic345.xbm"

#include "baby/b_pic015.xbm"
#include "baby/b_pic030.xbm"
#include "baby/b_pic060.xbm"
#include "baby/b_pic075.xbm"
#include "baby/b_pic105.xbm"
#include "baby/b_pic120.xbm"
#include "baby/b_pic150.xbm"
#include "baby/b_pic165.xbm"
#include "baby/b_pic195.xbm"
#include "baby/b_pic210.xbm"
#include "baby/b_pic240.xbm"
#include "baby/b_pic255.xbm"
#include "baby/b_pic285.xbm"
#include "baby/b_pic330.xbm"
#include "baby/b_pic300.xbm"
#include "baby/b_pic345.xbm"
#endif

#if BABY_ANGLE == 45
BabyMap BabyPix[2][BABY_HEADINGS] = {
	{{a_pic000_bits, None, a_pic000_height, a_pic000_width, 0.0, 0.0},
	 {a_pic045_bits, None, a_pic045_height, a_pic045_width, 0.0, 0.0},
	 {a_pic090_bits, None, a_pic090_height, a_pic090_width, 0.0, 0.0},
	 {a_pic135_bits, None, a_pic135_height, a_pic135_width, 0.0, 0.0},
	 {a_pic180_bits, None, a_pic180_height, a_pic180_width, 0.0, 0.0},
	 {a_pic225_bits, None, a_pic225_height, a_pic225_width, 0.0, 0.0},
	 {a_pic270_bits, None, a_pic270_height, a_pic270_width, 0.0, 0.0},
	 {a_pic315_bits, None, a_pic315_height, a_pic315_width, 0.0, 0.0}},
	{{b_pic000_bits, None, b_pic000_height, b_pic000_width, 0.0, 0.0},
	 {b_pic045_bits, None, b_pic045_height, b_pic045_width, 0.0, 0.0},
	 {b_pic090_bits, None, b_pic090_height, b_pic090_width, 0.0, 0.0},
	 {b_pic135_bits, None, b_pic135_height, b_pic135_width, 0.0, 0.0},
	 {b_pic180_bits, None, b_pic180_height, b_pic180_width, 0.0, 0.0},
	 {b_pic225_bits, None, b_pic225_height, b_pic225_width, 0.0, 0.0},
	 {b_pic270_bits, None, b_pic270_height, b_pic270_width, 0.0, 0.0},
	 {b_pic315_bits, None, b_pic315_height, b_pic315_width, 0.0, 0.0}},
};
#else
BabyMap BabyPix[2][BABY_HEADINGS] = {
       {{a_pic000_bits, None, a_pic000_height, a_pic000_width, 0.0, 0.0},
	{a_pic015_bits, None, a_pic015_height, a_pic015_width, 0.0, 0.0},
	{a_pic030_bits, None, a_pic030_height, a_pic030_width, 0.0, 0.0},
	{a_pic045_bits, None, a_pic045_height, a_pic045_width, 0.0, 0.0},
	{a_pic060_bits, None, a_pic060_height, a_pic060_width, 0.0, 0.0},
	{a_pic075_bits, None, a_pic075_height, a_pic075_width, 0.0, 0.0},
	{a_pic090_bits, None, a_pic090_height, a_pic090_width, 0.0, 0.0},
	{a_pic105_bits, None, a_pic105_height, a_pic105_width, 0.0, 0.0},
	{a_pic120_bits, None, a_pic120_height, a_pic120_width, 0.0, 0.0},
	{a_pic135_bits, None, a_pic135_height, a_pic135_width, 0.0, 0.0},
	{a_pic150_bits, None, a_pic150_height, a_pic150_width, 0.0, 0.0},
	{a_pic165_bits, None, a_pic165_height, a_pic165_width, 0.0, 0.0},
	{a_pic180_bits, None, a_pic180_height, a_pic180_width, 0.0, 0.0},
	{a_pic195_bits, None, a_pic195_height, a_pic195_width, 0.0, 0.0},
	{a_pic210_bits, None, a_pic210_height, a_pic210_width, 0.0, 0.0},
	{a_pic225_bits, None, a_pic225_height, a_pic225_width, 0.0, 0.0},
	{a_pic240_bits, None, a_pic240_height, a_pic240_width, 0.0, 0.0},
	{a_pic255_bits, None, a_pic255_height, a_pic255_width, 0.0, 0.0},
	{a_pic270_bits, None, a_pic270_height, a_pic270_width, 0.0, 0.0},
	{a_pic285_bits, None, a_pic285_height, a_pic285_width, 0.0, 0.0},
	{a_pic300_bits, None, a_pic300_height, a_pic300_width, 0.0, 0.0},
	{a_pic315_bits, None, a_pic315_height, a_pic315_width, 0.0, 0.0},
	{a_pic330_bits, None, a_pic330_height, a_pic330_width, 0.0, 0.0},
	{a_pic345_bits, None, a_pic345_height, a_pic345_width, 0.0, 0.0}},
       {{b_pic000_bits, None, b_pic000_height, b_pic000_width, 0.0, 0.0},
	{b_pic015_bits, None, b_pic015_height, b_pic015_width, 0.0, 0.0},
	{b_pic030_bits, None, b_pic030_height, b_pic030_width, 0.0, 0.0},
	{b_pic045_bits, None, b_pic045_height, b_pic045_width, 0.0, 0.0},
	{b_pic060_bits, None, b_pic060_height, b_pic060_width, 0.0, 0.0},
	{b_pic075_bits, None, b_pic075_height, b_pic075_width, 0.0, 0.0},
	{b_pic090_bits, None, b_pic090_height, b_pic090_width, 0.0, 0.0},
	{b_pic105_bits, None, b_pic105_height, b_pic105_width, 0.0, 0.0},
	{b_pic120_bits, None, b_pic120_height, b_pic120_width, 0.0, 0.0},
	{b_pic135_bits, None, b_pic135_height, b_pic135_width, 0.0, 0.0},
	{b_pic150_bits, None, b_pic150_height, b_pic150_width, 0.0, 0.0},
	{b_pic165_bits, None, b_pic165_height, b_pic165_width, 0.0, 0.0},
	{b_pic180_bits, None, b_pic180_height, b_pic180_width, 0.0, 0.0},
	{b_pic195_bits, None, b_pic195_height, b_pic195_width, 0.0, 0.0},
	{b_pic210_bits, None, b_pic210_height, b_pic210_width, 0.0, 0.0},
	{b_pic225_bits, None, b_pic225_height, b_pic225_width, 0.0, 0.0},
	{b_pic240_bits, None, b_pic240_height, b_pic240_width, 0.0, 0.0},
	{b_pic255_bits, None, b_pic255_height, b_pic255_width, 0.0, 0.0},
	{b_pic270_bits, None, b_pic270_height, b_pic270_width, 0.0, 0.0},
	{b_pic285_bits, None, b_pic285_height, b_pic285_width, 0.0, 0.0},
	{b_pic300_bits, None, b_pic300_height, b_pic300_width, 0.0, 0.0},
	{b_pic315_bits, None, b_pic315_height, b_pic315_width, 0.0, 0.0},
	{b_pic330_bits, None, b_pic330_height, b_pic330_width, 0.0, 0.0},
	{b_pic345_bits, None, b_pic345_height, b_pic345_width, 0.0, 0.0}},
};
#endif

