/*
 * Copyright (c) 1999, 2000, 2001, 2002 Seth Kingsley.  All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgment:
 *    This product includes software developed by Seth Kingsley and
 *    contributors.
 * 4. Neither the author's name, nor any of the contributors names may be
 *    used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include    <X11/Xlib.h>
#include    <X11/Intrinsic.h>
#include    <X11/Shell.h>
#include    <X11/StringDefs.h>

#include    <sysexits.h>

#ifndef lint
static const char   rcsid[] =
	"$Id: xbell.c,v 1.1 2002/10/27 00:26:48 sethk Exp $";
#endif /* !lint */

int
main(int ac, char *av[])
{
    struct res_data
    {
	int per;
    }			rdata;
    XtResource		rsrcs[] =
    {
	{
	    "percent", "Percent",
	    XtRInt, sizeof(int),
	    XtOffsetOf(struct res_data, per),
	    XtRImmediate, (XtPointer)33
	}
    };
    XrmOptionDescRec	opts[] =
    {
	{"-percent", ".percent", XrmoptionSepArg, NULL}
    };
    XtAppContext	xtac;
    Widget		top_w;
    Display		*dpy;

    dpy = XtDisplay(top_w = XtVaOpenApplication(&xtac,
		"XBell",
		opts, XtNumber(opts),
		&ac, av,
		NULL,
		applicationShellWidgetClass,
		NULL));
    XtVaGetApplicationResources(top_w,
	    &rdata,
	    rsrcs, XtNumber(rsrcs),
	    NULL);
    XBell(dpy, rdata.per);
    XCloseDisplay(dpy);
    return EX_OK;
}

