.\" vim: filetype=nroff
.\"
.\" Copyright (c) 1999, 2000, 2001, 2002 Seth Kingsley.  All rights reserved.
.\" 
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in the
.\"    documentation and/or other materials provided with the distribution.
.\" 3. All advertising materials mentioning features or use of this software
.\"    must display the following acknowledgment:
.\"    This product includes software developed by Seth Kingsley and
.\"    contributors.
.\" 4. Neither the author's name, nor any of the contributors names may be
.\"    used to endorse or promote products derived from this software without
.\"    specific prior written permission.
.\" 
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
.\" IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
.\" OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
.\" IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
.\" INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
.\" NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
.\" DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
.\" THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
.\" (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
.\" THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.\" $Id: xbelld.man,v 1.5 2002/10/27 02:36:35 sethk Exp $
.Dd March 19, 2002
.Os Version 0.2 BETA
.Dt xbelld 1 CON
.Sh NAME
.Nm xbelld
.Nd replace X11 terminal bells with different sounds
.Sh SYNOPSIS
.Bk
.Nm
.Op Po Cm + Ns | Ns Cm - Pc Ns Cm verbose
.Op Po Cm + Ns | Ns Cm - Pc Ns Cm nofork
.Op Fl volume Ar volume
.Op Fl cache Ar cache_size
.Op Po Cm + Ns | Ns Cm - Pc Ns Cm multi
.Op Fl pidfile Ar pid_file
.Op Fl dir Ar audio_dir
.Op Fl esdserver Ar esound_server
.Op toolkit options
.Ek
.Sh DESCRIPTION
.Nm Xbelld
is a small daemon for replacing the standard X Window System terminal
bell with a more interesting set of sounds. This is useful for systems
where the terminal bell is handled by the
.Dq "PC Speaker" ,
or where different sounds are desired for different classes of X
clients.
.Pp
.Nm Xbelld
works by intercepting terminal bell requests on the server side, and
then playing user-specified sounds through a PCM capable soundcard.
The resource class of the client making a terminal bell request is used
to match a corresponding sound file which should be played when such a
request is made.
.Pp
After starting,
.Nm
forks into the background and monitors the display specified for
incoming terminal bell requests. Sound files are selected from the
directory named in the
.Em audioDir
resource, using the client class name as the filename base. A file named
with
.Ql default
as a base is treated specially; it is used in the abscense of a match
against a given class name. If multiple files exist for a given class
name but with different suffixes, the order of preference is undefined.
See the section
.Sx EXAMPLES
for a set of example filenames. A wide variety of audio file formats are
supported, namely those that the library
.Dq libaudiofile
can read.
.Pp
The process exits when it receives a fatal signal or when its connection
to the display is shut down. Upon receiving a
.Dv SIGHUP
signal, the audio directory is examined for differences since the
process began, or since the last time it received a
.Dv SIGHUP .
.Nm Xbelld
does not explictly poll this directory for changes after starting.
.Pp
Below is a list of command options and their corresponding X resource
names. The default resource class is
.Ql XBellD .
.Bl -tag
.It Cm +verbose
Set the resource
.Em verbose
to
.Ql False
.Pq default .
.It Fl verbose
Set the resource
.Em verbose
to
.Ql True .
.Pp
A value of
.Ql True
indicates that extra diagnostic output should be produced.
.It Cm +nofork
Set the resource
.Em dontFork
to
.Ql False
.Pq default .
.It Fl nofork
Set the resource
.Em dontFork
to
.Ql True .
.Pp
A value of
.Ql True
indicates the program should run in the foreground rather than forking
off as a daemon.
.It Fl volume Ar volume
Set the resource
.Em volume
to the value specified
.Pq "default: 33" .
This must be an integral value in between -100 and 100. If the value is
positive, it is used as a percentage of the bell volume requested by the
client. A negative value indicates that the absolute value of the volume
should be used, regardless of what volume the client requests.
.It Fl cache Ar cache_size
Set the resource
.Em cacheSize
to the value specified
.Pq "default: 512" .
This will set the size of the audio data cache to
the number specified, in units of kilobytes.
.It Cm +multi
Set the resource
.Em multiplexAudio
to
.Ql False .
.It Fl multi
Set the resource
.Em multiplexAudio
to
.Ql True
.Pq default .
.Pp
This indicates sounds should be played using additional available audio
output channels, even if the soundcard is already active on another
channel.
.It Fl pidfile Ar pid_file
Set the resource
.Em pidFile
to the value specified
.Po
default:
.Ql "".
.Pc
This gives the location of a file that should be written with the
process-ID of the currently running
.Nm .
An empty value disables writing of the file.
.It Fl dir
Set the resource
.Em audioDir
to the value specified
.Po
Default:
.Pa ~/.xbells
.Pc .
This names the directory that will be searched
for audio files to match client class names.
.It Fl esdserver Ar esound_server
Set the resource
.Em esoundServer
to the value specified
.Po
Default
.Ql ""
.Pc .
This names the EsounD server to connect to. See the document,
.Pp
.Rs
.%T EsounD: The Enlightened Sound Daemon
.%A Eric 'Ricdude Mitchell
.Re
.Pp
for details.
.El
.Pp
In addition to the options listed above, all the standard X toolkit
options are supported
.Po
.Fl display ,
.Fl class ,
.Fl name ,
.Fl geom ,
etc.
.Pc
.Sh IMPLEMENTATION NOTES
Other software of this type utilize the
.Ev LD_PRELOAD
environment variable for overriding library calls. This approach has
several drawbacks and generates a lot of overhead on the client side.
It makes the assumption that the machine executing the client program is
the same as the one running the display server, which is contrary to the
architecture of X Window System. Additionally, it requires extra runtime linking
overhead for
.Em every single
program invoked within the client's environment, regardless of whether
the program actually makes any bell requests.
.Pp
.Nm Xbelld ,
on the other hand, uses the
.Ql DEC-XTRAP
extension to monitor requests of type
.Ql X_Bell
on the server side.
In addition, it has native support for playing audio files, and keeps a
user-configurable audio data cache, replaced in LRU order.
.Sh FILES
.Bl -tag -width ~/.xbells/xxx -compact
.It Pa ~/.xbells/
Default directory for audio files
.Po
resource name 
.Em audioDir
.Pc .
.El
.Sh EXAMPLES
An example audio file directory might contain the following files:
.Bl -tag -width default.auxxx -compact
.Pp
.It XTerm.au
Bell for the program
.Xr xterm 1 .
.It XBiff.au
Bell for the program
.Xr xbiff 1 .
.It default.au
Sound used for all other clients.
.El
.Sh COMPATIBILITY
.Nm Xbelld
will work with X servers that follow the extension framework conventions
of the MIT sample server. The server extension
.Ql DEC-XTRAP
must be compiled into the server or loaded as a module
.Pq typically named Ql libxtrap.so .
.Sh SEE ALSO
.Xr XBell 3X11 ,
.Xr xtrap 1 .
.Rs
.%T XTrap: The XTrap Architecture
.%A Alan Jamison
.%Q Digital Equipment Corporation
.Re
.Sh AUTHORS
The
.Nm
software and this manual page were written by
.An "Seth Kingsley" Aq sethk@meowfishies.com .
